"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDataGridHeaderStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../../global_styling");
var _data_grid = require("../../data_grid.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiDataGridHeaderStyles = exports.euiDataGridHeaderStyles = function euiDataGridHeaderStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiDataGridVariables = (0, _data_grid.euiDataGridVariables)(euiThemeContext),
    levels = _euiDataGridVariables.levels;
  return {
    euiDataGridHeader: /*#__PURE__*/(0, _react.css)("z-index:", levels.stickyHeader, ";position:sticky;", (0, _global_styling.logicalCSS)('top', 0), " ", (0, _global_styling.logicalCSS)('width', 'fit-content'), " display:flex;;label:euiDataGridHeader;"),
    underline: /*#__PURE__*/(0, _react.css)("background-color:", euiTheme.colors.emptyShade, ";", (0, _global_styling.logicalCSS)('border-bottom', "".concat(euiTheme.border.width.thick, " solid ").concat(euiTheme.colors.textParagraph)), ";;label:underline;"),
    shade: /*#__PURE__*/(0, _react.css)("background-color:", euiTheme.colors.lightestShade, ";;label:shade;")
  };
};