"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiCheckableCardStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiCheckableCardStyles = exports.euiCheckableCardStyles = function euiCheckableCardStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var padding = (0, _global_styling.euiPaddingSize)(euiThemeContext, 'm');
  return {
    euiCheckableCard: /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{transition:border-color ", euiTheme.animation.normal, " ease-in;};label:euiCheckableCard;"),
    isChecked: /*#__PURE__*/(0, _react.css)("border-color:", euiTheme.colors.primary, ";;label:isChecked;"),
    label: {
      euiCheckableCard__label: /*#__PURE__*/(0, _react.css)("cursor:pointer;display:block;", _global_styling.logicals.width, ":calc(100% + (", padding, " * 2));padding:", padding, ";margin:-", padding, ";;label:euiCheckableCard__label;"),
      isDisabled: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.disabledText, ";cursor:not-allowed;;label:isDisabled;")
    },
    euiCheckableCard__children: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-top', euiTheme.size.base), ";;label:euiCheckableCard__children;")
  };
};