"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.POSITIONS = exports.EuiSkipLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _tabbable = require("tabbable");
var _services = require("../../../services");
var _button = require("../../button/button");
var _screen_reader_only = require("../screen_reader_only");
var _skip_link = require("./skip_link.styles");
var _react2 = require("@emotion/react");
var _excluded = ["destinationId", "fallbackDestination", "overrideLinkBehavior", "tabIndex", "position", "children", "className", "onClick"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var POSITIONS = exports.POSITIONS = ['static', 'fixed', 'absolute'];
var EuiSkipLink = exports.EuiSkipLink = function EuiSkipLink(_ref) {
  var destinationId = _ref.destinationId,
    _ref$fallbackDestinat = _ref.fallbackDestination,
    fallbackDestination = _ref$fallbackDestinat === void 0 ? 'main' : _ref$fallbackDestinat,
    overrideLinkBehavior = _ref.overrideLinkBehavior,
    tabIndex = _ref.tabIndex,
    _ref$position = _ref.position,
    position = _ref$position === void 0 ? 'static' : _ref$position,
    children = _ref.children,
    className = _ref.className,
    _onClick = _ref.onClick,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiSkipLink', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_skip_link.euiSkipLinkStyles);
  var cssStyles = [styles.euiSkipLink, position !== 'static' ? styles[position] : undefined];
  var onClick = (0, _react.useCallback)(function (e) {
    var destinationEl = null;
    // Check if the destination ID is valid
    destinationEl = document.getElementById(destinationId);
    var hasValidId = !!destinationEl;
    // Check the fallback destination if not
    if (!destinationEl && fallbackDestination) {
      if (Array.isArray(fallbackDestination)) {
        for (var i = 0; i < fallbackDestination.length; i++) {
          destinationEl = document.querySelector(fallbackDestination[i]);
          if (destinationEl) break; // Stop once the first fallback has been found
        }
      } else {
        destinationEl = document.querySelector(fallbackDestination);
      }
    }
    if ((overrideLinkBehavior || !hasValidId) && destinationEl) {
      e.preventDefault();

      // Scroll to the top of the destination content only if it's ~mostly out of view
      var destinationY = destinationEl.getBoundingClientRect().top;
      var halfOfViewportHeight = window.innerHeight / 2;
      if (destinationY >= halfOfViewportHeight || window.scrollY >= destinationY + halfOfViewportHeight) {
        destinationEl.scrollIntoView();
      }

      // Ensure the destination content is focusable
      if (!(0, _tabbable.isTabbable)(destinationEl)) {
        destinationEl.tabIndex = -1;
        destinationEl.addEventListener('blur', function () {
          var _destinationEl;
          return (_destinationEl = destinationEl) === null || _destinationEl === void 0 ? void 0 : _destinationEl.removeAttribute('tabindex');
        }, {
          once: true
        });
      }
      destinationEl.focus({
        preventScroll: true
      }); // Scrolling is already handled above, and focus autoscroll behaves oddly on Chrome around fixed headers
    }
    _onClick === null || _onClick === void 0 || _onClick(e);
  }, [overrideLinkBehavior, destinationId, fallbackDestination, _onClick]);
  return (0, _react2.jsx)(_screen_reader_only.EuiScreenReaderOnly, {
    showOnFocus: true
  }, (0, _react2.jsx)(_button.EuiButton, _extends({
    css: cssStyles,
    className: classes,
    tabIndex: position === 'fixed' ? 0 : tabIndex,
    size: "s",
    fill: true,
    href: "#".concat(destinationId),
    onClick: onClick
  }, rest), children));
};
EuiSkipLink.propTypes = {
  href: _propTypes.default.string,
  onClick: _propTypes.default.func,
  /**
     * Change the display position of the element when focused.
     * If 'fixed', the link will be fixed to the top left of the viewport
     */
  position: _propTypes.default.any,
  /**
     * Typically an anchor id (e.g. `a11yMainContent`), the value provided
     * will be prepended with a hash `#` and used as the link `href`
     */
  destinationId: _propTypes.default.string.isRequired,
  /**
     * If no destination ID element exists or can be found, you may provide a query selector
     * string to fall back to.
     *
     * For complex applications with potentially variable layouts per page, an array of
     * query selectors can be passed, e.g. `['main', '[role=main]', '.appWrapper']`, which
     * prioritizes looking for multiple fallbacks based on array order.
     * @default main
     */
  fallbackDestination: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.arrayOf(_propTypes.default.string.isRequired).isRequired]),
  /**
     * If default HTML anchor link behavior is not desired (e.g. for SPAs with hash routing),
     * setting this flag to true will manually scroll to and focus the destination element
     * without changing the browser URL's hash
     */
  overrideLinkBehavior: _propTypes.default.bool,
  /**
     * When position is fixed, this is forced to `0`
     */
  tabIndex: _propTypes.default.number,
  children: _propTypes.default.node,
  /**
     * Make button a solid color for prominence
     */
  fill: _propTypes.default.bool,
  /**
     * Any of the named color palette options.
     *
     * Do not use the following colors for standalone buttons directly,
     * they exist to serve other components:
     *  - accent
     *  - warning
     *  - neutral
     *  - risk
     */
  color: _propTypes.default.any,
  /**
     * Use size `s` in confined spaces
     */
  size: _propTypes.default.any,
  /**
     * `disabled` is also allowed
     */
  isDisabled: _propTypes.default.bool,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  buttonRef: _propTypes.default.any
};