"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.chartTypeFromSpecs = chartTypeFromSpecs;
const chart_types_1 = require("../chart_types");
const common_1 = require("../utils/common");
const logger_1 = require("../utils/logger");
function chartTypeFromSpecs(specs) {
    const nonGlobalTypes = Object.values(specs)
        .map((s) => s.chartType)
        .filter((type) => type !== chart_types_1.ChartType.Global)
        .filter(common_1.keepDistinct);
    if (!nonGlobalTypes[0]) {
        logger_1.Logger.warn(`${nonGlobalTypes.length === 0 ? 'Zero' : 'Multiple'} chart types in the same configuration`);
        return null;
    }
    return nonGlobalTypes[0];
}
//# sourceMappingURL=chart_type_from_specs.js.map