"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.lineGenerator = lineGenerator;
exports.areaGenerator = areaGenerator;
const d3_shape_1 = require("d3-shape");
const curves_1 = require("../utils/curves");
function lineGenerator(xProject, yProject, defined, curve) {
    const generator = (0, d3_shape_1.line)().x(xProject).y(yProject).defined(defined).curve((0, curves_1.getCurveFactory)(curve));
    return (d) => generator(d) ?? '';
}
function areaGenerator(xProject, y0Project, y1Project, defined, curve) {
    const generator = (0, d3_shape_1.area)().x(xProject).y0(y0Project).y1(y1Project).defined(defined).curve((0, curves_1.getCurveFactory)(curve));
    return {
        y0: (d) => generator.lineY0()(d) ?? '',
        y1: (d) => generator.lineY1()(d) ?? '',
        area: (d) => generator(d) ?? '',
    };
}
//# sourceMappingURL=path.js.map