"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LegendTableHeader = void 0;
const react_1 = __importDefault(require("react"));
const legend_table_cell_1 = require("./legend_table_cell");
const legend_table_row_1 = require("./legend_table_row");
const legend_value_1 = require("./legend_value");
const legend_1 = require("../../../common/legend");
const label_1 = require("../label");
const LegendTableHeader = ({ hasAction, legendValues, legendTitle = '', isMostlyRTL, labelOptions, }) => {
    return (react_1.default.createElement("div", { role: "rowgroup", className: "echLegendTable__rowgroup echLegendTable__header" },
        react_1.default.createElement(legend_table_row_1.LegendTableRow, { className: "echLegendTable__item echLegendTable__item--vertical", dir: isMostlyRTL ? 'rtl' : 'ltr' },
            react_1.default.createElement(legend_table_cell_1.LegendTableCell, { className: "echLegend__colorWrapper echLegendTable__colorCell" }),
            react_1.default.createElement(legend_table_cell_1.LegendTableCell, null,
                react_1.default.createElement(label_1.NonInteractiveLabel, { label: legendTitle, options: labelOptions })),
            legendValues.map((l) => (react_1.default.createElement(legend_table_cell_1.LegendTableCell, { key: l },
                react_1.default.createElement(legend_value_1.LegendValueComponent, { label: legend_1.legendValueTitlesMap[l] })))),
            hasAction && react_1.default.createElement(legend_table_cell_1.LegendTableCell, null))));
};
exports.LegendTableHeader = LegendTableHeader;
//# sourceMappingURL=legend_table_header.js.map