"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNullDataState = exports.updateDataState = exports.invalid = void 0;
const invalid = (dataState, dataDemand) => !dataState.valid ||
    dataState.binUnit !== dataDemand.binUnit ||
    dataState.binUnitCount !== dataDemand.binUnitCount ||
    (dataDemand.lo?.minimum ?? -Infinity) < (dataState.lo?.minimum ?? -Infinity) ||
    (dataDemand.hi?.minimum ?? Infinity) > (dataState.hi?.minimum ?? Infinity);
exports.invalid = invalid;
const updateDataState = (dataState, dataDemand, dataResponse) => {
    dataState.pending = false;
    dataState.valid = true;
    dataState.lo = dataDemand.lo;
    dataState.hi = dataDemand.hi;
    dataState.binUnit = dataDemand.binUnit;
    dataState.binUnitCount = dataDemand.binUnitCount;
    dataState.dataResponse = dataResponse;
};
exports.updateDataState = updateDataState;
const getNullDataState = () => ({
    valid: false,
    pending: false,
    lo: { minimum: Infinity, supremum: Infinity, labelSupremum: Infinity },
    hi: { minimum: -Infinity, supremum: -Infinity, labelSupremum: -Infinity },
    binUnit: 'year',
    binUnitCount: NaN,
    dataResponse: { stats: { minValue: NaN, maxValue: NaN }, rows: [] },
});
exports.getNullDataState = getNullDataState;
//# sourceMappingURL=data_fetch.js.map