"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.chartSelectorsFactory = void 0;
const get_chart_type_description_1 = require("./selectors/get_chart_type_description");
const get_goal_spec_1 = require("./selectors/get_goal_spec");
const is_tooltip_visible_1 = require("./selectors/is_tooltip_visible");
const on_element_click_caller_1 = require("./selectors/on_element_click_caller");
const on_element_out_caller_1 = require("./selectors/on_element_out_caller");
const on_element_over_caller_1 = require("./selectors/on_element_over_caller");
const tooltip_1 = require("./selectors/tooltip");
const chart_selectors_1 = require("../../../state/chart_selectors");
const get_active_pointer_position_1 = require("../../../state/selectors/get_active_pointer_position");
const get_internal_is_intialized_1 = require("../../../state/selectors/get_internal_is_intialized");
exports.chartSelectorsFactory = (0, chart_selectors_1.createChartSelectorsFactory)({
    isInitialized: (state) => (0, get_goal_spec_1.getGoalSpecSelector)(state) !== null ? get_internal_is_intialized_1.InitStatus.Initialized : get_internal_is_intialized_1.InitStatus.ChartNotInitialized,
    isChartEmpty: () => false,
    isTooltipVisible: (state) => ({
        visible: (0, is_tooltip_visible_1.isTooltipVisibleSelector)(state),
        isExternal: false,
        displayOnly: false,
        isPinnable: false,
    }),
    getTooltipInfo: tooltip_1.getTooltipInfoSelector,
    getTooltipAnchor: (state) => {
        const position = (0, get_active_pointer_position_1.getActivePointerPosition)(state);
        return {
            isRotated: false,
            x: position.x,
            width: 0,
            y: position.y,
            height: 0,
        };
    },
    getChartTypeDescription: get_chart_type_description_1.getChartTypeDescriptionSelector,
    canDisplayChartTitles: () => false,
}, [on_element_click_caller_1.createOnElementClickCaller, on_element_over_caller_1.createOnElementOverCaller, on_element_out_caller_1.createOnElementOutCaller]);
//# sourceMappingURL=chart_selectors.js.map