// src/stream-callbacks.ts
function createCallbacksTransformer(callbacks = {}) {
  let aggregatedResponse = "";
  return new TransformStream({
    async start() {
      if (callbacks.onStart) await callbacks.onStart();
    },
    async transform(message, controller) {
      controller.enqueue(message);
      aggregatedResponse += message;
      if (callbacks.onToken) await callbacks.onToken(message);
      if (callbacks.onText && typeof message === "string") {
        await callbacks.onText(message);
      }
    },
    async flush() {
      if (callbacks.onFinal) {
        await callbacks.onFinal(aggregatedResponse);
      }
    }
  });
}

// src/langchain-adapter.ts
function toUIMessageStream(stream, callbacks) {
  return stream.pipeThrough(
    new TransformStream({
      transform: async (value, controller) => {
        var _a;
        if (typeof value === "string") {
          controller.enqueue(value);
          return;
        }
        if ("event" in value) {
          if (value.event === "on_chat_model_stream") {
            forwardAIMessageChunk(
              (_a = value.data) == null ? void 0 : _a.chunk,
              controller
            );
          }
          return;
        }
        forwardAIMessageChunk(value, controller);
      }
    })
  ).pipeThrough(createCallbacksTransformer(callbacks)).pipeThrough(
    new TransformStream({
      start: async (controller) => {
        controller.enqueue({ type: "text-start", id: "1" });
      },
      transform: async (chunk, controller) => {
        controller.enqueue({ type: "text-delta", delta: chunk, id: "1" });
      },
      flush: async (controller) => {
        controller.enqueue({ type: "text-end", id: "1" });
      }
    })
  );
}
function forwardAIMessageChunk(chunk, controller) {
  if (typeof chunk.content === "string") {
    controller.enqueue(chunk.content);
  } else {
    const content = chunk.content;
    for (const item of content) {
      if (item.type === "text") {
        controller.enqueue(item.text);
      }
    }
  }
}
export {
  toUIMessageStream
};
//# sourceMappingURL=index.mjs.map