"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WelcomeService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class WelcomeService {
  constructor() {
    (0, _defineProperty2.default)(this, "onRenderedHandlers", []);
    (0, _defineProperty2.default)(this, "renderTelemetryNoticeHandler", void 0);
    (0, _defineProperty2.default)(this, "setup", () => {
      return {
        registerOnRendered: onRendered => {
          this.onRenderedHandlers.push(onRendered);
        },
        registerTelemetryNoticeRenderer: renderTelemetryNotice => {
          if (this.renderTelemetryNoticeHandler) {
            throw new Error('Only one renderTelemetryNotice handler can be registered');
          }
          this.renderTelemetryNoticeHandler = renderTelemetryNotice;
        }
      };
    });
    (0, _defineProperty2.default)(this, "onRendered", () => {
      this.onRenderedHandlers.forEach(onRendered => {
        try {
          onRendered();
        } catch (err) {
          // eslint-disable-next-line no-console
          console.error(err);
        }
      });
    });
    (0, _defineProperty2.default)(this, "renderTelemetryNotice", () => {
      if (this.renderTelemetryNoticeHandler) {
        try {
          return this.renderTelemetryNoticeHandler();
        } catch (err) {
          // eslint-disable-next-line no-console
          console.error(err);
        }
      }
      return null;
    });
  }
}
exports.WelcomeService = WelcomeService;