"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationsHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _use_read_only_context = require("../../hooks/use_read_only_context");
var _header_portal = require("./header_portal");
var _deployment_details = require("./deployment_details");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IntegrationsHeader = ({
  setHeaderActionMenu,
  startServices
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const readOnlyBtnClass = _react.default.useMemo(() => {
    return (0, _css.css)`
      color: ${euiTheme.colors.text};
    `;
  }, [euiTheme]);
  const isReadOnly = (0, _use_read_only_context.useIsReadOnly)();
  return /*#__PURE__*/_react.default.createElement(_header_portal.HeaderPortal, {
    setHeaderActionMenu,
    startServices
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSection, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, null, /*#__PURE__*/_react.default.createElement(_deployment_details.DeploymentDetails, null))), isReadOnly ? /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrations.header.readOnlyTooltip",
      defaultMessage: "You can view Integrations, but to perform all actions you need additional privileges."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: 'glasses',
    className: readOnlyBtnClass,
    disabled: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.header.readOnlyBtn",
    defaultMessage: "Read-only"
  }))))) : null));
};
exports.IntegrationsHeader = IntegrationsHeader;