"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUiSettings = exports.getTheme = exports.getSettings = exports.getSavedObjectsClient = exports.getHttp = exports.getDocLinks = exports.getDataViewsService = void 0;
exports.setStartServices = setStartServices;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let coreStart;
let pluginsStart;
function setStartServices(core, plugins) {
  coreStart = core;
  pluginsStart = plugins;
}
const getDocLinks = () => coreStart.docLinks;
exports.getDocLinks = getDocLinks;
const getDataViewsService = () => pluginsStart.data.dataViews;
exports.getDataViewsService = getDataViewsService;
const getHttp = () => coreStart.http;
exports.getHttp = getHttp;
const getSavedObjectsClient = () => coreStart.savedObjects.client;
exports.getSavedObjectsClient = getSavedObjectsClient;
const getUiSettings = () => coreStart.settings.client;
exports.getUiSettings = getUiSettings;
const getSettings = () => coreStart.settings;
exports.getSettings = getSettings;
const getTheme = () => coreStart.theme;
exports.getTheme = getTheme;