"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldFormatsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("../common");
var _lib = require("./lib");
require("./index.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class FieldFormatsPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "fieldFormatsRegistry", new _common.FieldFormatsRegistry());
  }
  setup(core) {
    core.uiSettings.getUpdate$().subscribe(({
      key,
      newValue
    }) => {
      if (key === _common.FORMATS_UI_SETTINGS.FORMAT_DEFAULT_TYPE_MAP) {
        this.fieldFormatsRegistry.parseDefaultTypeMap(newValue);
      }
    });
    const getConfig = core.uiSettings.get.bind(core.uiSettings);
    this.fieldFormatsRegistry.init(getConfig, {
      parsedUrl: {
        origin: window.location.origin,
        pathname: window.location.pathname,
        basePath: core.http.basePath.get()
      }
    }, _lib.baseFormattersPublic);
    return this.fieldFormatsRegistry;
  }
  start() {
    return this.fieldFormatsRegistry;
  }
  stop() {}
}

/** @public */

/** @public */
exports.FieldFormatsPlugin = FieldFormatsPlugin;