"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fieldsSuggestionsAfter = void 0;
var _esqlAst = require("@kbn/esql-ast");
var _uniqBy = _interopRequireDefault(require("lodash/uniqBy"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fieldsSuggestionsAfter = (command, previousCommandFields, userDefinedColumns) => {
  const {
    target
  } = command;
  return (0, _uniqBy.default)([...previousCommandFields, {
    name: target ? _esqlAst.LeafPrinter.column(target.type) : 'type',
    type: 'keyword'
  }, {
    name: target ? _esqlAst.LeafPrinter.column(target.pvalue) : 'pvalue',
    type: 'double'
  }], 'name');
};
exports.fieldsSuggestionsAfter = fieldsSuggestionsAfter;