"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSampleCommand = void 0;
var _factories = require("../factories");
var _walkers = require("../walkers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createSampleCommand = ctx => {
  const command = (0, _factories.createCommand)('sample', ctx);
  if (ctx.constant()) {
    const probability = (0, _walkers.getConstant)(ctx.constant());
    if (probability != null) {
      command.args.push(probability);
    }
  }
  return command;
};
exports.createSampleCommand = createSampleCommand;