"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCompletionCommand = void 0;
var _ = require("../../..");
var _walkers = require("../walkers");
var _factories = require("../factories");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createCompletionCommand = ctx => {
  var _ctx$_inferenceId;
  const command = (0, _factories.createCommand)('completion', ctx);
  if (ctx._targetField && ctx.ASSIGN()) {
    const targetField = (0, _factories.createColumn)(ctx._targetField);
    const prompt = (0, _walkers.visitPrimaryExpression)(ctx._prompt);
    command.prompt = prompt;
    const assignment = (0, _factories.createFunction)(ctx.ASSIGN().getText(), ctx, undefined, 'binary-expression');
    assignment.args.push(targetField, prompt);
    // update the location of the assign based on arguments
    assignment.location = (0, _factories.computeLocationExtends)(assignment);
    command.targetField = targetField;
    command.args.push(assignment);
  } else if (ctx._prompt) {
    const prompt = (0, _walkers.visitPrimaryExpression)(ctx._prompt);
    command.prompt = prompt;
    command.args.push(prompt);
  } else {
    // When the user is typing a column as prompt i.e: | COMPLETION message^,
    // ANTLR does not know if it is trying to type a prompt
    // or a target field, so it does not return neither _prompt nor _targetField. We fill the AST
    // with an unknown item until the user inserts the next keyword and breaks the tie.
    const unknownItem = (0, _factories.createUnknownItem)(ctx);
    unknownItem.text = ctx.getText().replace(/^completion/i, '');
    command.prompt = unknownItem;
    command.args.push(unknownItem);
  }
  const withCtx = ctx.WITH();
  let inferenceId;
  let withIncomplete = true;
  const withText = withCtx === null || withCtx === void 0 ? void 0 : withCtx.getText();
  const inferenceIdText = (_ctx$_inferenceId = ctx._inferenceId) === null || _ctx$_inferenceId === void 0 ? void 0 : _ctx$_inferenceId.getText();
  if (withText !== null && withText !== void 0 && withText.includes('missing') && /(?:w|wi|wit|with)$/i.test(inferenceIdText)) {
    // This case is when the WITH keyword is partially typed, and no inferenceId has been provided e.g. 'COMPLETION "prompt" WI'
    // (the parser incorrectly recognizes the partial WITH keyword as the inferenceId)
    inferenceId = _.Builder.identifier('', {
      incomplete: true
    });
  } else {
    if (!inferenceIdText) {
      inferenceId = _.Builder.identifier('', {
        incomplete: true
      });
    } else {
      withIncomplete = false;
      inferenceId = (0, _factories.createIdentifierOrParam)(ctx._inferenceId);
    }
  }
  command.inferenceId = inferenceId;
  const optionWith = _.Builder.option({
    name: 'with',
    args: [inferenceId]
  }, {
    incomplete: withIncomplete,
    ...(withCtx && ctx._inferenceId ? {
      location: (0, _helpers.getPosition)(withCtx.symbol, ctx._inferenceId.stop)
    } : undefined)
  });
  command.args.push(optionWith);
  return command;
};
exports.createCompletionCommand = createCompletionCommand;