"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetupGuide = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _doc_links = require("../../../shared/doc_links");
var _kibana_chrome = require("../../../shared/kibana_chrome");
var _setup_guide = require("../../../shared/setup_guide");
var _telemetry = require("../../../shared/telemetry");
var _getting_started = _interopRequireDefault(require("./assets/getting_started.png"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GETTING_STARTED_LINK_URL = _doc_links.docLinks.workplaceSearchGettingStarted;
const SetupGuide = () => {
  return /*#__PURE__*/_react.default.createElement(_setup_guide.SetupGuideLayout, {
    productName: _constants.WORKPLACE_SEARCH_PLUGIN.NAME,
    productEuiIcon: "logoWorkplaceSearch"
  }, /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetWorkplaceSearchChrome, {
    trail: [_setup_guide.SETUP_GUIDE_TITLE]
  }), /*#__PURE__*/_react.default.createElement(_telemetry.SendWorkplaceSearchTelemetry, {
    action: "viewed",
    metric: "setup_guide"
  }), /*#__PURE__*/_react.default.createElement("img", {
    className: "setupGuide__thumbnail",
    src: _getting_started.default,
    alt: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.setupGuide.imageAlt', {
      defaultMessage: 'Getting started with Workplace Search - a guide to show you how to get Workplace Search up and running'
    }),
    width: "1280",
    height: "720"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.setupGuide.description",
    defaultMessage: "Unify your content platforms, such as Google Drive and Salesforce, into a personalized search experience."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    target: "_blank",
    fill: true,
    href: GETTING_STARTED_LINK_URL,
    iconType: "popout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.setupGuide.button",
    defaultMessage: "Get started with Workplace Search"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.setupGuide.notConfigured",
    defaultMessage: "Workplace Search isn't configured in Kibana. Follow the instructions on this page."
  }))));
};
exports.SetupGuide = SetupGuide;