"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSettingsSubNav = void 0;
var _reactRouterDom = require("react-router-dom");
var _layout = require("../../../../shared/layout");
var _constants = require("../../../constants");
var _routes = require("../../../routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSettingsSubNav = () => {
  const isSettingsPage = !!(0, _reactRouterDom.useRouteMatch)(_routes.ORG_SETTINGS_PATH);
  if (!isSettingsPage) return undefined;
  const navItems = [{
    id: 'settingsCustomize',
    name: _constants.NAV.SETTINGS_CUSTOMIZE,
    ...(0, _layout.generateNavLink)({
      to: _routes.ORG_SETTINGS_CUSTOMIZE_PATH
    })
  }, {
    id: 'settingsConnectors',
    name: _constants.NAV.SETTINGS_SOURCE_PRIORITIZATION,
    ...(0, _layout.generateNavLink)({
      to: _routes.ORG_SETTINGS_CONNECTORS_PATH,
      shouldShowActiveForSubroutes: true
    })
  }, {
    id: 'settingsOAuth',
    name: _constants.NAV.SETTINGS_OAUTH,
    ...(0, _layout.generateNavLink)({
      to: _routes.ORG_SETTINGS_OAUTH_APPLICATION_PATH
    })
  }];
  return navItems;
};
exports.useSettingsSubNav = useSettingsSubNav;