"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OauthApplication = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _doc_links = require("../../../../shared/doc_links");
var _licensing = require("../../../../shared/licensing");
var _layout = require("../../../components/layout");
var _content_section = require("../../../components/shared/content_section");
var _credential_item = require("../../../components/shared/credential_item");
var _license_badge = require("../../../components/shared/license_badge");
var _constants = require("../../../constants");
var _settings_logic = require("../settings_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OauthApplication = () => {
  const {
    setOauthApplication,
    updateOauthApplication
  } = (0, _kea.useActions)(_settings_logic.SettingsLogic);
  const {
    oauthApplication
  } = (0, _kea.useValues)(_settings_logic.SettingsLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  if (!oauthApplication) return null;
  const persisted = !!(oauthApplication.uid && oauthApplication.secret);
  const description = persisted ? _constants.OAUTH_PERSISTED_DESCRIPTION : _constants.OAUTH_DESCRIPTION;
  const insecureRedirectUri = /(^|\s)http:/i.test(oauthApplication.redirectUri);
  const redirectUris = oauthApplication.redirectUri.split('\n').map(uri => uri.trim());
  const uniqRedirectUri = Array.from(new Set(redirectUris));
  const redirectUriInvalid = insecureRedirectUri || redirectUris.length !== uniqRedirectUri.length;
  const redirectUriHelpText = /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement("strong", null, _constants.REDIRECT_HELP_TEXT), ' ', oauthApplication.nativeRedirectUri && /*#__PURE__*/_react.default.createElement("span", null, _constants.REDIRECT_NATIVE_HELP_TEXT, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, oauthApplication.nativeRedirectUri)));
  const redirectErrorText = insecureRedirectUri ? _constants.REDIRECT_INSECURE_ERROR_TEXT : _constants.REDIRECT_SECURE_ERROR_TEXT;
  const handleSubmit = e => {
    e.preventDefault();
    updateOauthApplication();
  };
  const nonPlatinumTitle = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_license_badge.LicenseBadge, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", null, _constants.NON_PLATINUM_OAUTH_TITLE)));
  const nonPlatinumDescription = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, _constants.NON_PLATINUM_OAUTH_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    external: true,
    target: "_blank",
    href: _doc_links.docLinks.licenseManagement
  }, _constants.EXPLORE_PLATINUM_FEATURES_LINK));
  return /*#__PURE__*/_react.default.createElement(_layout.WorkplaceSearchPageTemplate, {
    pageChrome: [_constants.NAV.SETTINGS, _constants.NAV.SETTINGS_OAUTH],
    pageHeader: {
      pageTitle: hasPlatinumLicense ? _constants.NAV.SETTINGS_OAUTH : nonPlatinumTitle,
      description: hasPlatinumLicense ? description : nonPlatinumDescription
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _constants.NAME_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: oauthApplication.name,
    "data-test-subj": "OAuthAppName",
    onChange: e => setOauthApplication({
      ...oauthApplication,
      name: e.target.value
    }),
    required: true,
    disabled: !hasPlatinumLicense
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "RedirectURIsRow",
    label: _constants.REDIRECT_URIS_LABEL,
    helpText: redirectUriHelpText,
    isInvalid: redirectUriInvalid,
    error: redirectErrorText
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    value: oauthApplication.redirectUri,
    "data-test-subj": "RedirectURIsTextArea",
    onChange: e => setOauthApplication({
      ...oauthApplication,
      redirectUri: e.target.value
    }),
    required: true,
    disabled: !hasPlatinumLicense
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: _constants.CONFIDENTIAL_HELP_TEXT
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _constants.CONFIDENTIAL_LABEL,
    checked: oauthApplication.confidential,
    "data-test-subj": "ConfidentialToggle",
    onChange: e => setOauthApplication({
      ...oauthApplication,
      confidential: e.target.checked
    }),
    disabled: !hasPlatinumLicense
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    "data-test-subj": "SaveOAuthApp",
    type: "submit",
    disabled: !hasPlatinumLicense
  }, _constants.SAVE_CHANGES_BUTTON)), persisted && /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, {
    title: _constants.CREDENTIALS_TITLE,
    description: _constants.CREDENTIALS_DESCRIPTION
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_credential_item.CredentialItem, {
    label: _constants.CLIENT_ID_LABEL,
    value: oauthApplication.uid,
    testSubj: "ClientID"
  })), oauthApplication.confidential && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_credential_item.CredentialItem, {
    label: _constants.CLIENT_SECRET_LABEL,
    value: oauthApplication.secret,
    testSubj: "ClientSecret"
  }))))));
};
exports.OauthApplication = OauthApplication;