"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupSources = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _source_icon = require("../../../components/shared/source_icon");
var _constants = require("../../../constants");
var _group_row_sources_dropdown = require("./group_row_sources_dropdown");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GroupSources = ({
  groupSources
}) => {
  const [popoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const closePopover = () => setPopoverOpen(false);
  const togglePopover = () => setPopoverOpen(!popoverOpen);
  const hiddenSources = [...groupSources];
  const visibleSources = hiddenSources.splice(0, _constants.MAX_TABLE_ROW_ICONS);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, visibleSources.map((source, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_source_icon.SourceIcon, (0, _extends2.default)({}, source, {
    size: "l"
  }))))), hiddenSources.length > 0 && /*#__PURE__*/_react.default.createElement(_group_row_sources_dropdown.GroupRowSourcesDropdown, {
    isPopoverOpen: popoverOpen,
    numOptions: hiddenSources.length,
    groupSources: groupSources,
    onButtonClick: togglePopover,
    closePopover: closePopover
  }));
};
exports.GroupSources = GroupSources;