"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupRowSourcesDropdown = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _source_option_item = require("./source_option_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GroupRowSourcesDropdown = ({
  isPopoverOpen,
  numOptions,
  groupSources,
  onButtonClick,
  closePopover
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const toggleLink = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    className: "user-group-source--additional",
    onClick: onButtonClick
  }, "+ ", numOptions);
  const contentSourceCountHeading = /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.contentSourceCountHeading', {
    defaultMessage: '{numSources} organizational content sources',
    values: {
      numSources: groupSources.length
    }
  }));
  const sources = groupSources.map((source, index) => /*#__PURE__*/_react.default.createElement("div", {
    className: "euiFilterSelectItem user-group__item",
    key: index
  }, /*#__PURE__*/_react.default.createElement(_source_option_item.SourceOptionItem, {
    source: groupSources.filter(({
      id
    }) => id === source.id)[0]
  })));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    className: "user-group-source--additional__wrap"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: toggleLink,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, contentSourceCountHeading), /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-yScroll",
    css: {
      maxHeight: euiTheme.base * 30
    }
  }, sources)));
};
exports.GroupRowSourcesDropdown = GroupRowSourcesDropdown;