"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupOverview = exports.EMPTY_SOURCES_DESCRIPTION = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _truncate = require("../../../../shared/truncate");
var _share_circle = _interopRequireDefault(require("../../../assets/share_circle.svg"));
var _layout = require("../../../components/layout");
var _content_section = require("../../../components/shared/content_section");
var _sources_table = require("../../../components/shared/sources_table");
var _constants = require("../../../constants");
var _routes = require("../../../routes");
var _group_logic = require("../group_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_SOURCES_DESCRIPTION = exports.EMPTY_SOURCES_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.overview.emptySourcesDescription', {
  defaultMessage: 'No content sources are shared with this group.'
});
const USERS_SECTION_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.overview.usersSectionTitle', {
  defaultMessage: 'Group users'
});
const GROUP_USERS_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.overview.groupUsersDescription', {
  defaultMessage: "Users assigned to this group gain access to the sources' data and content defined above. User assignments for this group can be managed in the Users and Roles area."
});
const MANAGE_SOURCES_BUTTON_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.overview.manageSourcesButtonText', {
  defaultMessage: 'Manage organizational content sources'
});
const MANAGE_USERS_BUTTON_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.overview.manageUsersButtonText', {
  defaultMessage: 'Manage users and roles'
});
const NAME_SECTION_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.overview.nameSectionTitle', {
  defaultMessage: 'Group name'
});
const NAME_SECTION_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.overview.nameSectionDescription', {
  defaultMessage: 'Customize the name of this group.'
});
const SAVE_NAME_BUTTON_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.overview.saveNameButtonText', {
  defaultMessage: 'Save name'
});
const REMOVE_SECTION_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.overview.removeSectionTitle', {
  defaultMessage: 'Remove this group'
});
const REMOVE_SECTION_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.overview.removeSectionDescription', {
  defaultMessage: 'This action cannot be undone.'
});
const REMOVE_BUTTON_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.overview.removeButtonText', {
  defaultMessage: 'Remove group'
});
const CONFIRM_TITLE_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.overview.confirmTitleText', {
  defaultMessage: 'Confirm'
});
const GroupOverview = () => {
  const {
    deleteGroup,
    showOrgSourcesModal,
    showConfirmDeleteModal,
    hideConfirmDeleteModal,
    updateGroupName,
    onGroupNameInputChange
  } = (0, _kea.useActions)(_group_logic.GroupLogic);
  const {
    group: {
      name,
      contentSources,
      canDeleteGroup
    },
    groupNameInputValue,
    dataLoading,
    confirmDeleteModalVisible
  } = (0, _kea.useValues)(_group_logic.GroupLogic);
  const truncatedName = name && /*#__PURE__*/_react.default.createElement(_truncate.TruncatedContent, {
    tooltipType: "title",
    content: name,
    length: _group_logic.MAX_NAME_LENGTH
  });
  const CONFIRM_REMOVE_BUTTON_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.overview.confirmRemoveButtonText', {
    defaultMessage: 'Delete {name}',
    values: {
      name
    }
  });
  const CONFIRM_REMOVE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.overview.confirmRemoveDescription', {
    defaultMessage: 'Your group will be deleted from Workplace Search. Are you sure you want to remove {name}?',
    values: {
      name
    }
  });
  const GROUP_SOURCES_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.overview.groupSourcesTitle', {
    defaultMessage: 'Group content sources'
  });
  const GROUP_SOURCES_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.overview.groupSourcesDescription', {
    defaultMessage: 'Searchable by all users in the "{name}" group.',
    values: {
      name
    }
  });
  const hasContentSources = (contentSources === null || contentSources === void 0 ? void 0 : contentSources.length) > 0;
  const manageSourcesButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    onClick: showOrgSourcesModal
  }, MANAGE_SOURCES_BUTTON_TEXT);
  const manageUsersButton = /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    color: "primary",
    to: _routes.USERS_AND_ROLES_PATH
  }, MANAGE_USERS_BUTTON_TEXT);
  const sourcesTable = /*#__PURE__*/_react.default.createElement(_sources_table.SourcesTable, {
    sources: contentSources
  });
  const sourcesSection = /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, {
    title: GROUP_SOURCES_TITLE,
    description: GROUP_SOURCES_DESCRIPTION,
    action: manageSourcesButton,
    "data-test-subj": "GroupContentSourcesSection"
  }, sourcesTable);
  const sourcesEmptyState = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: _share_circle.default,
    title: /*#__PURE__*/_react.default.createElement("h2", null, GROUP_SOURCES_TITLE),
    body: /*#__PURE__*/_react.default.createElement("p", null, EMPTY_SOURCES_DESCRIPTION),
    actions: manageSourcesButton
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  const usersSection = /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, {
    title: USERS_SECTION_TITLE,
    description: GROUP_USERS_DESCRIPTION,
    "data-test-subj": "GroupUsersSection"
  }, manageUsersButton);
  const handleSubmit = e => {
    e.preventDefault();
    updateGroupName();
  };
  const nameSection = /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, {
    title: NAME_SECTION_TITLE,
    description: NAME_SECTION_DESCRIPTION
  }, /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: false,
    value: groupNameInputValue,
    onChange: e => onGroupNameInputChange(e.target.value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !groupNameInputValue,
    onClick: updateGroupName
  }, SAVE_NAME_BUTTON_TEXT))))));
  const deleteSection = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, {
    title: REMOVE_SECTION_TITLE,
    description: REMOVE_SECTION_DESCRIPTION
  }, confirmDeleteModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    onCancel: hideConfirmDeleteModal,
    onConfirm: deleteGroup,
    confirmButtonText: CONFIRM_REMOVE_BUTTON_TEXT,
    title: CONFIRM_TITLE_TEXT,
    cancelButtonText: _constants.CANCEL_BUTTON,
    defaultFocusedButton: "confirm"
  }, CONFIRM_REMOVE_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    "data-test-subj": "DeleteGroup",
    fill: true,
    onClick: showConfirmDeleteModal
  }, REMOVE_BUTTON_TEXT)));
  return /*#__PURE__*/_react.default.createElement(_layout.WorkplaceSearchPageTemplate, {
    pageChrome: [_constants.NAV.GROUPS, name || '...'],
    pageViewTelemetry: "group_overview",
    pageHeader: {
      pageTitle: truncatedName
    },
    isLoading: dataLoading
  }, hasContentSources ? sourcesSection : sourcesEmptyState, usersSection, nameSection, canDeleteGroup && deleteSection);
};
exports.GroupOverview = GroupOverview;