"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BlockedWindowItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../shared/constants");
var _constants2 = require("../../../../constants");
var _types = require("../../../../types");
var _constants3 = require("../../constants");
var _source_logic = require("../../source_logic");
var _synchronization_logic = require("./synchronization_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const syncOptions = [{
  value: 'full',
  inputDisplay: _constants3.FULL_SYNC_LABEL,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, _constants3.FULL_SYNC_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _constants3.FULL_SYNC_DESCRIPTION))
}, {
  value: 'incremental',
  inputDisplay: _constants3.INCREMENTAL_SYNC_LABEL,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, _constants3.INCREMENTAL_SYNC_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _constants3.INCREMENTAL_SYNC_DESCRIPTION))
}, {
  value: 'delete',
  inputDisplay: _constants3.DELETION_SYNC_LABEL,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, _constants3.DELETION_SYNC_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _constants3.DELETION_SYNC_DESCRIPTION))
}, {
  value: 'permissions',
  inputDisplay: _constants3.PERMISSIONS_SYNC_LABEL,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, _constants3.PERMISSIONS_SYNC_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _constants3.PERMISSIONS_SYNC_DESCRIPTION))
}];
const daySelectOptions = _types.DAYS_OF_WEEK_VALUES.map(day => ({
  text: _constants.DAYS_OF_WEEK_LABELS[day.toUpperCase()],
  value: day
}));
daySelectOptions.push({
  text: _constants.ALL_DAYS_LABEL,
  value: 'all'
});
const BlockedWindowItem = ({
  blockedWindow,
  index
}) => {
  const {
    contentSource
  } = (0, _kea.useValues)(_source_logic.SourceLogic);
  const {
    removeBlockedWindow,
    setBlockedTimeWindow
  } = (0, _kea.useActions)((0, _synchronization_logic.SynchronizationLogic)({
    contentSource
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _constants2.BLOCK_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 175
    },
    className: "blockedItemSyncSelect"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    valueOfSelected: blockedWindow.jobType,
    options: syncOptions,
    onChange: value => setBlockedTimeWindow(index, 'jobType', value),
    itemClassName: "blockedWindowSelectItem",
    popoverProps: {
      className: 'blockedWindowSelectPopover'
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _constants2.ON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: 130
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    value: blockedWindow.day,
    onChange: e => setBlockedTimeWindow(index, 'day', e.target.value),
    options: daySelectOptions
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _constants2.BETWEEN_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePickerRange, {
    startDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      showTimeSelect: true,
      showTimeSelectOnly: true,
      selected: (0, _moment.default)(blockedWindow.start, 'HH:mm:ssZ').utc(),
      onChange: value => value && setBlockedTimeWindow(index, 'start', `${value.utc().format('HH:mm:ss')}Z`),
      dateFormat: "h:mm A",
      timeFormat: "h:mm A"
    }),
    endDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      showTimeSelect: true,
      showTimeSelectOnly: true,
      selected: (0, _moment.default)(blockedWindow.end, 'HH:mm:ssZ').utc(),
      onChange: value => value && setBlockedTimeWindow(index, 'end', `${value.utc().format('HH:mm:ss')}Z`),
      dateFormat: "h:mm A",
      timeFormat: "h:mm A"
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    title: _constants3.UTC_TITLE,
    type: "iInCircle",
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.workplaceSearch.sources.utcLabel",
      defaultMessage: "Current UTC time: {utcTime}",
      values: {
        utcTime: (0, _moment.default)().utc().format('h:mm A')
      }
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "base",
    iconType: "trash",
    color: "danger",
    onClick: () => removeBlockedWindow(index),
    "aria-label": _constants2.REMOVE_BUTTON,
    title: _constants2.REMOVE_BUTTON
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
};
exports.BlockedWindowItem = BlockedWindowItem;