"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetsAndObjects = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../shared/constants");
var _doc_links = require("../../../../../shared/doc_links");
var _unsaved_changes_prompt = require("../../../../../shared/unsaved_changes_prompt");
var _view_content_header = require("../../../../components/shared/view_content_header");
var _constants2 = require("../../../../constants");
var _constants3 = require("../../constants");
var _source_logic = require("../../source_logic");
var _source_layout = require("../source_layout");
var _indexing_rules_table = require("./indexing_rules_table");
var _synchronization_logic = require("./synchronization_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssetsAndObjects = () => {
  const {
    contentSource,
    dataLoading
  } = (0, _kea.useValues)(_source_logic.SourceLogic);
  const {
    thumbnailsChecked,
    contentExtractionChecked,
    hasUnsavedAssetsAndObjectsChanges
  } = (0, _kea.useValues)((0, _synchronization_logic.SynchronizationLogic)({
    contentSource
  }));
  const {
    setThumbnailsChecked,
    setContentExtractionChecked,
    updateAssetsAndObjectsSettings,
    resetSyncSettings
  } = (0, _kea.useActions)((0, _synchronization_logic.SynchronizationLogic)({
    contentSource
  }));
  const {
    areThumbnailsConfigEnabled
  } = contentSource;
  const actions = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: updateAssetsAndObjectsSettings,
    disabled: !hasUnsavedAssetsAndObjectsChanges
  }, _constants.SAVE_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: resetSyncSettings,
    disabled: !hasUnsavedAssetsAndObjectsChanges
  }, _constants2.RESET_BUTTON)));
  return /*#__PURE__*/_react.default.createElement(_source_layout.SourceLayout, {
    pageChrome: [_constants2.NAV.SYNCHRONIZATION_ASSETS_AND_OBJECTS],
    pageViewTelemetry: "source_synchronization",
    isLoading: dataLoading
  }, /*#__PURE__*/_react.default.createElement(_unsaved_changes_prompt.UnsavedChangesPrompt, {
    hasUnsavedChanges: hasUnsavedAssetsAndObjectsChanges,
    messageText: _constants3.SYNC_UNSAVED_CHANGES_MESSAGE
  }), /*#__PURE__*/_react.default.createElement(_view_content_header.ViewContentHeader, {
    title: _constants2.NAV.SYNCHRONIZATION_ASSETS_AND_OBJECTS,
    action: actions
  }), _constants3.SOURCE_ASSETS_AND_OBJECTS_DESCRIPTION, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.workplaceSearchSynch,
    external: true
  }, _constants3.SOURCE_ASSETS_AND_OBJECTS_LEARN_MORE_LINK), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _constants3.SOURCE_ASSETS_AND_OBJECTS_ASSETS_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: thumbnailsChecked,
    onChange: e => setThumbnailsChecked(e.target.checked),
    label: areThumbnailsConfigEnabled ? _constants3.SYNC_MANAGEMENT_THUMBNAILS_LABEL : _constants3.SYNC_MANAGEMENT_THUMBNAILS_GLOBAL_CONFIG_LABEL,
    disabled: !areThumbnailsConfigEnabled,
    "data-test-subj": "ThumbnailsToggle"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: contentExtractionChecked,
    onChange: e => setContentExtractionChecked(e.target.checked),
    label: _constants3.SYNC_MANAGEMENT_CONTENT_EXTRACTION_LABEL,
    "data-test-subj": "ContentExtractionToggle"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _constants3.SOURCE_ASSETS_AND_OBJECTS_OBJECTS_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_indexing_rules_table.IndexingRulesTable, null))));
};
exports.AssetsAndObjects = AssetsAndObjects;