"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TablePaginationBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_PAGES = 100;
const TablePaginationBar = ({
  itemLabel = 'Items',
  itemsPerPage = 10,
  totalPages,
  totalItems,
  activePage = 1,
  showPerPageOptions = false,
  hideLabelCount = false,
  onChangePage,
  clearFiltersLink
}) => {
  // EUI component starts page at 0. API starts at 1.
  const currentPage = activePage - 1;
  const showAllPages = totalPages < MAX_PAGES;
  const pageRangeText = () => {
    const rangeEnd = activePage === totalPages ? totalItems : itemsPerPage * activePage;
    const rangeStart = currentPage * itemsPerPage + 1;
    const rangeEl = /*#__PURE__*/_react.default.createElement("strong", null, rangeStart, "-", rangeEnd);
    const totalEl = /*#__PURE__*/_react.default.createElement("strong", null, totalItems.toLocaleString());
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "flexStart"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("div", null, "Showing ", rangeEl, showAllPages && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', "of ", totalEl, " ", itemLabel))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, clearFiltersLink));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, !hideLabelCount && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, pageRangeText()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    showPerPageOptions: showPerPageOptions,
    activePage: currentPage,
    itemsPerPage: itemsPerPage,
    pageCount: showAllPages ? totalPages : MAX_PAGES,
    onChangePage: onChangePage
  })));
};
exports.TablePaginationBar = TablePaginationBar;