"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudSetupInstructions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable sort-keys */

const CloudSetupInstructions = ({
  productName,
  cloudDeploymentLink
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
  headingElement: "h2",
  steps: [{
    title: _i18n.i18n.translate('xpack.enterpriseSearch.setupGuide.cloud.step1.title', {
      defaultMessage: 'Edit your deployment’s configuration'
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.setupGuide.cloud.step1.instruction1",
      defaultMessage: "Visit the Elastic Cloud console to {editDeploymentLink}.",
      values: {
        editDeploymentLink: cloudDeploymentLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: cloudDeploymentLink + '/edit',
          target: "_blank"
        }, _i18n.i18n.translate('xpack.enterpriseSearch.setupGuide.cloud.step1.instruction1LinkText', {
          defaultMessage: 'edit your deployment'
        })) : _i18n.i18n.translate('xpack.enterpriseSearch.setupGuide.cloud.step1.instruction1LinkText', {
          defaultMessage: 'edit your deployment'
        })
      }
    })))
  }, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.setupGuide.cloud.step2.title', {
      defaultMessage: 'Enable Enterprise Search for your deployment'
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.setupGuide.cloud.step2.instruction1",
      defaultMessage: "Once you're within your deployment's \u201CEdit deployment\u201D screen, scroll to the Enterprise Search configuration and select \u201CEnable\u201D."
    })))
  }, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.setupGuide.cloud.step3.title', {
      defaultMessage: 'Configure your Enterprise Search instance'
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.setupGuide.cloud.step3.instruction1",
      defaultMessage: "After enabling Enterprise Search for your instance you can customize the instance, including fault tolerance, RAM, and other {optionsLink}.",
      values: {
        optionsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _doc_links.docLinks.enterpriseSearchConfig,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.enterpriseSearch.setupGuide.cloud.step3.instruction1LinkText', {
          defaultMessage: 'configurable options'
        }))
      }
    })))
  }, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.setupGuide.cloud.step4.title', {
      defaultMessage: 'Save your deployment configuration'
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.setupGuide.cloud.step4.instruction1",
      defaultMessage: "Once you click \u201CSave\u201D, you'll see a confirmation dialog summarizing the changes being made to your deployment. Once you confirm, your deployment will process the configuration change, which should only take a few moments."
    })))
  }, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.setupGuide.cloud.step5.title', {
      defaultMessage: '{productName} is now available to use',
      values: {
        productName
      }
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.setupGuide.cloud.step5.instruction1",
      defaultMessage: "For {productName} indices that contain time-series statistical data, you may want to {configurePolicyLink}, so as to ensure optimal performance and cost-effective storage in the long run.",
      values: {
        productName,
        configurePolicyLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _doc_links.docLinks.cloudIndexManagement,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.enterpriseSearch.setupGuide.cloud.step5.instruction1LinkText', {
          defaultMessage: 'configure an index lifecycle policy'
        }))
      }
    })))
  }, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.setupGuide.cloud.step6.title', {
      defaultMessage: 'Troubleshooting issues'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.setupGuide.cloud.step6.instruction1",
      defaultMessage: "For help with common setup issues, read our {link} guide.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _doc_links.docLinks.enterpriseSearchTroubleshootSetup,
          target: "_blank",
          external: true
        }, _i18n.i18n.translate('xpack.enterpriseSearch.setupGuide.cloud.step6.instruction1LinkText', {
          defaultMessage: 'Troubleshoot Enterprise Search setup'
        }))
      }
    }))))
  }]
}));
exports.CloudSetupInstructions = CloudSetupInstructions;