"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _doc_links = require("../doc_links");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const USERS_DOCS_URL = `${_doc_links.docLinks.enterpriseSearchUsersAccess}`;
const UsersEmptyPrompt = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  justifyContent: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  style: {
    maxWidth: 700,
    margin: '0 auto'
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  iconType: "user",
  title: /*#__PURE__*/_react.default.createElement("h2", null, _constants.NO_USERS_TITLE),
  body: /*#__PURE__*/_react.default.createElement("p", null, _constants.NO_USERS_DESCRIPTION),
  actions: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: USERS_DOCS_URL,
    target: "_blank",
    external: true
  }, _constants.ENABLE_USERS_LINK)
}))));
exports.UsersEmptyPrompt = UsersEmptyPrompt;