"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserInvitationCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserInvitationCallout = ({
  isNew,
  invitationCode,
  urlPrefix
}) => {
  const link = `${urlPrefix}/invitations/${invitationCode}`;
  const label = isNew ? _constants.NEW_INVITATION_LABEL : _constants.EXISTING_INVITATION_LABEL;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isNew && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _constants.INVITATION_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "enterpriseSearchUserInvitationCalloutLink",
    href: link,
    target: "_blank",
    external: true
  }, _constants.INVITATION_LINK), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: link
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "enterpriseSearchUserInvitationCalloutButton",
    iconType: "copy",
    onClick: copy,
    "aria-label": _constants.INVITATION_LINK_COPY_ARIA_LABEL
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.UserInvitationCallout = UserInvitationCallout;