"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetWorkplaceSearchChrome = exports.SetVectorSearchChrome = exports.SetSemanticSearchChrome = exports.SetSearchPlaygroundChrome = exports.SetSearchExperiencesChrome = exports.SetSearchChrome = exports.SetEnterpriseSearchContentChrome = exports.SetEnterpriseSearchApplicationsChrome = exports.SetElasticsearchChrome = exports.SetAppSearchChrome = exports.SetAnalyticsChrome = exports.SetAiSearchChrome = void 0;
var _react = require("react");
var _kea = require("kea");
var _constants = require("../../../../common/constants");
var _kibana = require("../kibana");
var _generate_breadcrumbs = require("./generate_breadcrumbs");
var _generate_title = require("./generate_title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Helpers for setting Kibana chrome (breadcrumbs, doc titles) on React view mount
 * @see https://github.com/elastic/kibana/blob/main/src/core/packages/chrome/browser-internal/src/chrome_service.tsx
 *
 * Example usage (don't forget to i18n.translate() page titles!):
 *
 * <SetAppSearchPageChrome trail={['Engines', 'Example Engine Name, 'Curations']} />
 * Breadcrumb output: Enterprise Search > App Search > Engines > Example Engine Name > Curations
 * Title output: Curations - Example Engine Name - Engines - App Search - Elastic
 *
 * <SetWorkplaceSearchChrome />
 * Breadcrumb output: Enterprise Search > Workplace Search
 * Title output: Workplace Search - Elastic
 */

const SetSearchChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.searchTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useSearchBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail.join('|')]);
  return null;
};
exports.SetSearchChrome = SetSearchChrome;
const SetAnalyticsChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.analyticsTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useAnalyticsBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetAnalyticsChrome = SetAnalyticsChrome;
const SetElasticsearchChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.elasticsearchTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useElasticsearchBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetElasticsearchChrome = SetElasticsearchChrome;
const SetAppSearchChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.appSearchTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useAppSearchBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetAppSearchChrome = SetAppSearchChrome;
const SetAiSearchChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.aiSearchTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useAiSearchBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetAiSearchChrome = SetAiSearchChrome;
const SetWorkplaceSearchChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.workplaceSearchTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useWorkplaceSearchBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetWorkplaceSearchChrome = SetWorkplaceSearchChrome;
const SetEnterpriseSearchContentChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.enterpriseSearchContentTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useEnterpriseSearchContentBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetEnterpriseSearchContentChrome = SetEnterpriseSearchContentChrome;
const SetSearchExperiencesChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.searchExperiencesTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useSearchExperiencesBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetSearchExperiencesChrome = SetSearchExperiencesChrome;
const SetSearchPlaygroundChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.generateTitle)(title);
  const breadcrumbs = (0, _generate_breadcrumbs.useEnterpriseSearchApplicationsBreadcrumbs)((0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail));
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetSearchPlaygroundChrome = SetSearchPlaygroundChrome;
const SetEnterpriseSearchApplicationsChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.searchApplicationsTitle)(title);
  const breadcrumbs = (0, _generate_breadcrumbs.useEnterpriseSearchApplicationsBreadcrumbs)((0, _generate_breadcrumbs.useGenerateBreadcrumbs)([_constants.SEARCH_APPS_BREADCRUMB, ...trail]));
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetEnterpriseSearchApplicationsChrome = SetEnterpriseSearchApplicationsChrome;
const SetVectorSearchChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.vectorSearchTitle)(title);
  const breadcrumbs = (0, _generate_breadcrumbs.useVectorSearchBreadcrumbs)((0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail));
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetVectorSearchChrome = SetVectorSearchChrome;
const SetSemanticSearchChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.semanticSearchTitle)(title);
  const breadcrumbs = (0, _generate_breadcrumbs.useSemanticSearchBreadcrumbs)((0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail));
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};

// Small util - performantly reverses an array without mutating the original array
exports.SetSemanticSearchChrome = SetSemanticSearchChrome;
const reverseArray = array => array.slice().reverse();