"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndicesNav = void 0;
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _kibana = require("../../../../shared/kibana");
var _layout = require("../../../../shared/layout");
var _routes = require("../../../routes");
var _indices = require("../../../utils/indices");
var _index_view_logic = require("../index_view_logic");
var _search_index = require("../search_index");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIndicesNav = () => {
  const isIndexRoute = !!(0, _reactRouterDom.useRouteMatch)(_routes.SEARCH_INDEX_PATH);
  const {
    indexName
  } = (0, _reactRouterDom.useParams)();
  const {
    hasFilteringFeature,
    index
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    productFeatures: {
      hasDefaultIngestPipeline
    }
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  if (!indexName || !isIndexRoute) return undefined;
  const navItems = [{
    'data-test-subj': 'IndexLabel',
    id: 'indexName',
    name: indexName.toUpperCase(),
    ...(0, _layout.generateNavLink)({
      to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_PATH, {
        indexName
      })
    }),
    items: [{
      'data-test-subj': 'IndexOverviewLink',
      id: 'overview',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchIndicesTitle.nav.overviewTitle', {
        defaultMessage: 'Overview'
      }),
      ...(0, _layout.generateNavLink)({
        to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
          indexName,
          tabId: _search_index.SearchIndexTabId.OVERVIEW
        })
      })
    }, {
      'data-test-subj': 'IndexDocumentsLink',
      id: 'documents',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchIndicesTitle.nav.documentsTitle', {
        defaultMessage: 'Documents'
      }),
      ...(0, _layout.generateNavLink)({
        to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
          indexName,
          tabId: _search_index.SearchIndexTabId.DOCUMENTS
        })
      })
    }, {
      'data-test-subj': 'IndexIndexMappingsLink',
      id: 'index_mappings',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchIndicesTitle.nav.indexMappingsTitle', {
        defaultMessage: 'Index mappings'
      }),
      ...(0, _layout.generateNavLink)({
        to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
          indexName,
          tabId: _search_index.SearchIndexTabId.INDEX_MAPPINGS
        })
      })
    }, ...((0, _indices.isConnectorIndex)(index) ? [{
      'data-test-subj': 'IndexConnectorsConfigurationLink',
      id: 'connectors_configuration',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchIndicesTitle.nav.connectorsConfigurationLabel', {
        defaultMessage: 'Configuration'
      }),
      ...(0, _layout.generateNavLink)({
        to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
          indexName,
          tabId: _search_index.SearchIndexTabId.CONFIGURATION
        })
      })
    }, ...(hasFilteringFeature ? [{
      'data-test-subj': 'IndexSyncRulesLink',
      id: 'syncRules',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchIndicesTitle.nav.syncRulesLabel', {
        defaultMessage: 'Sync rules'
      }),
      ...(0, _layout.generateNavLink)({
        to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
          indexName,
          tabId: _search_index.SearchIndexTabId.SYNC_RULES
        })
      })
    }] : []), {
      'data-test-subj': 'IndexSchedulingLink',
      id: 'scheduling',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchIndicesTitle.nav.schedulingTitle', {
        defaultMessage: 'Scheduling'
      }),
      ...(0, _layout.generateNavLink)({
        to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
          indexName,
          tabId: _search_index.SearchIndexTabId.SCHEDULING
        })
      })
    }] : []), ...((0, _indices.isCrawlerIndex)(index) ? [{
      'data-test-subj': 'IndexDomainManagementLink',
      id: 'domain_management',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchIndicesTitle.nav.domainManagementLabel', {
        defaultMessage: 'Manage Domains'
      }),
      ...(0, _layout.generateNavLink)({
        shouldShowActiveForSubroutes: true,
        to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
          indexName,
          tabId: _search_index.SearchIndexTabId.DOMAIN_MANAGEMENT
        })
      })
    }, {
      'data-test-subj': 'IndexCrawlerConfigurationLink',
      id: 'crawler_configuration',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchIndicesTitle.nav.crawlerConfigurationLabel', {
        defaultMessage: 'Configuration'
      }),
      ...(0, _layout.generateNavLink)({
        to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
          indexName,
          tabId: _search_index.SearchIndexTabId.CRAWLER_CONFIGURATION
        })
      })
    }, {
      'data-test-subj': 'IndexCrawlerSchedulingLink',
      id: 'crawler_scheduling',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchIndicesTitle.nav.crawlerSchedulingLabel', {
        defaultMessage: 'Scheduling'
      }),
      ...(0, _layout.generateNavLink)({
        to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
          indexName,
          tabId: _search_index.SearchIndexTabId.SCHEDULING
        })
      })
    }] : []), ...(hasDefaultIngestPipeline ? [{
      'data-test-subj': 'IndexPipelineLink',
      id: 'pipelines',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.nav.searchIndicesTitle.nav.pipelinesLabel', {
        defaultMessage: 'Pipelines'
      }),
      ...(0, _layout.generateNavLink)({
        to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
          indexName,
          tabId: _search_index.SearchIndexTabId.PIPELINES
        })
      })
    }] : [])]
  }];
  return navItems;
};
exports.useIndicesNav = useIndicesNav;