"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexError = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../shared/kibana");
var _mappings_logic = require("../../api/mappings/mappings_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isInferencePreconfigured = inferenceId => inferenceId.startsWith('.');
const parseMapping = mappings => {
  const fields = mappings.properties;
  if (!fields) {
    return [];
  }
  return getSemanticTextFields(fields, '');
};
const getSemanticTextFields = (fields, path) => {
  return Object.entries(fields).flatMap(([key, value]) => {
    const currentPath = path ? `${path}.${key}` : key;
    const currentField = value.type === 'semantic_text' ? [{
      path: currentPath,
      source: value
    }] : [];
    if (hasProperties(value)) {
      const childSemanticTextFields = value.properties ? getSemanticTextFields(value.properties, currentPath) : [];
      return [...currentField, ...childSemanticTextFields];
    }
    return currentField;
  });
};
function hasProperties(field) {
  return !!field.properties;
}
function isLocalModel(model) {
  return ['elser', 'elasticsearch'].includes(model.service);
}
const IndexError = ({
  indexName
}) => {
  const {
    makeRequest: makeMappingRequest
  } = (0, _kea.useActions)((0, _mappings_logic.mappingsWithPropsApiLogic)(indexName));
  const {
    data
  } = (0, _kea.useValues)((0, _mappings_logic.mappingsWithPropsApiLogic)(indexName));
  const {
    ml
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const [errors, setErrors] = (0, _react.useState)([]);
  const [showErrors, setShowErrors] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    makeMappingRequest({
      indexName
    });
  }, [indexName]);
  (0, _react.useEffect)(() => {
    const mappings = data === null || data === void 0 ? void 0 : data.mappings;
    if (!mappings || !ml) {
      return;
    }
    const semanticTextFields = parseMapping(mappings);
    const fetchErrors = async () => {
      var _ml$mlApi, _ml$mlApi2;
      const trainedModelStats = await (ml === null || ml === void 0 ? void 0 : (_ml$mlApi = ml.mlApi) === null || _ml$mlApi === void 0 ? void 0 : _ml$mlApi.trainedModels.getTrainedModelStats());
      const endpoints = await (ml === null || ml === void 0 ? void 0 : (_ml$mlApi2 = ml.mlApi) === null || _ml$mlApi2 === void 0 ? void 0 : _ml$mlApi2.inferenceModels.getAllInferenceEndpoints());
      if (!trainedModelStats || !endpoints) {
        return [];
      }
      const semanticTextFieldsWithErrors = semanticTextFields.map(field => {
        const model = endpoints.endpoints.find(endpoint => endpoint.inference_id === field.source.inference_id);
        if (!model) {
          return {
            error: _i18n.i18n.translate('xpack.enterpriseSearch.indexOverview.indexErrors.missingModelError', {
              defaultMessage: 'Inference endpoint {inferenceId} not found',
              values: {
                inferenceId: field.source.inference_id
              }
            }),
            field
          };
        }
        if (isLocalModel(model) && !isInferencePreconfigured(model.inference_id)) {
          var _modelStats$deploymen;
          const modelId = model.service_settings.model_id;
          const modelStats = trainedModelStats === null || trainedModelStats === void 0 ? void 0 : trainedModelStats.trained_model_stats.find(value => {
            var _value$deployment_sta;
            return value.model_id === modelId && ((_value$deployment_sta = value.deployment_stats) === null || _value$deployment_sta === void 0 ? void 0 : _value$deployment_sta.deployment_id) === field.source.inference_id;
          });
          if (!modelStats || ((_modelStats$deploymen = modelStats.deployment_stats) === null || _modelStats$deploymen === void 0 ? void 0 : _modelStats$deploymen.state) !== 'started') {
            return {
              error: _i18n.i18n.translate('xpack.enterpriseSearch.indexOverview.indexErrors.modelNotDeployedError', {
                defaultMessage: 'Model {modelId} for inference endpoint {inferenceId} in field {fieldName} has not been started',
                values: {
                  fieldName: field.path,
                  inferenceId: field.source.inference_id,
                  modelId
                }
              }),
              field
            };
          }
        }
        return {
          error: '',
          field
        };
      }).filter(value => !!value.error);
      setErrors(semanticTextFieldsWithErrors);
    };
    if (semanticTextFields.length) {
      fetchErrors();
    }
  }, [data]);
  return errors.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "indexErrorCallout",
    color: "danger",
    iconType: "error",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.indexOverview.indexErrors.title', {
      defaultMessage: 'Index has errors'
    })
  }, showErrors && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.indexOverview.indexErrors.body', {
    defaultMessage: 'Found errors in the following fields:'
  }), errors.map(({
    field,
    error
  }) => /*#__PURE__*/_react.default.createElement("li", {
    key: field.path
  }, /*#__PURE__*/_react.default.createElement("strong", null, field.path), ": ", error))), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchIndexErrorHideFullErrorButton",
    color: "danger",
    onClick: () => setShowErrors(false)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.indexOverview.indexErrors.hideErrorsLabel', {
    defaultMessage: 'Hide full error'
  }))), !showErrors && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchIndexErrorShowFullErrorButton",
    color: "danger",
    onClick: () => setShowErrors(true)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.indexOverview.indexErrors.showErrorsLabel', {
    defaultMessage: 'Show full error'
  }))) : null;
};
exports.IndexError = IndexError;