"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthenticationPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _page_introduction = require("../../../../../../shared/page_introduction/page_introduction");
var _auth_panel_delete_confirm_modal = require("./auth_panel_delete_confirm_modal");
var _authentication_panel_actions = require("./authentication_panel_actions");
var _authentication_panel_edit_content = require("./authentication_panel_edit_content");
var _authentication_panel_logic = require("./authentication_panel_logic");
var _authentication_panel_view_content = require("./authentication_panel_view_content");
require("./authentication_panel.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AuthenticationPanel = () => {
  const {
    isEditing,
    isModalVisible
  } = (0, _kea.useValues)(_authentication_panel_logic.AuthenticationPanelLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "authenticationPanel"
  }, /*#__PURE__*/_react.default.createElement(_page_introduction.PageIntroduction, {
    actions: [/*#__PURE__*/_react.default.createElement(_authentication_panel_actions.AuthenticationPanelActions, null)],
    description: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.crawler.authenticationPanel.description",
      defaultMessage: "Setup authentication to enable crawling protected content for this domain."
    })),
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.authenticationPanel.title', {
      defaultMessage: 'Authentication'
    })))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), isEditing ? /*#__PURE__*/_react.default.createElement(_authentication_panel_edit_content.AuthenticationPanelEditContent, null) : /*#__PURE__*/_react.default.createElement(_authentication_panel_view_content.AuthenticationPanelViewContent, null)), isModalVisible && /*#__PURE__*/_react.default.createElement(_auth_panel_delete_confirm_modal.AuthenticationPanelDeleteConfirmationModal, null));
};
exports.AuthenticationPanel = AuthenticationPanel;