"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSyncRules = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _doc_links = require("../../../../../shared/doc_links");
var _sync_rules_helpers = require("../../../../utils/sync_rules_helpers");
var _connector_view_logic = require("../../../connector_detail/connector_view_logic");
var _filtering_rules_table = require("../../../shared/filtering_rules_table/filtering_rules_table");
var _connector_filtering_logic = require("./connector_filtering_logic");
var _edit_sync_rules_flyout = require("./edit_sync_rules_flyout");
var _sync_rules_callouts = require("./sync_rules_callouts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorSyncRules = () => {
  const {
    indexName,
    hasAdvancedFilteringFeature,
    hasBasicFilteringFeature
  } = (0, _kea.useValues)(_connector_view_logic.ConnectorViewLogic);
  const {
    applyDraft,
    setLocalFilteringRules,
    setLocalAdvancedSnippet,
    setIsEditing
  } = (0, _kea.useActions)(_connector_filtering_logic.ConnectorFilteringLogic);
  const {
    advancedSnippet,
    draftErrors,
    draftState,
    filteringRules,
    hasDraft,
    isEditing
  } = (0, _kea.useValues)(_connector_filtering_logic.ConnectorFilteringLogic);
  const isAdvancedSnippetEmpty = (0, _sync_rules_helpers.isAdvancedSyncRuleSnippetEmpty)(advancedSnippet);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isEditing && /*#__PURE__*/_react.default.createElement(_edit_sync_rules_flyout.EditSyncRulesFlyout, {
    errors: draftErrors,
    hasAdvancedFilteringFeature: hasAdvancedFilteringFeature,
    hasBasicFilteringFeature: hasBasicFilteringFeature,
    revertLocalFilteringRules: () => setLocalFilteringRules(filteringRules),
    revertLocalAdvancedFiltering: () => setLocalAdvancedSnippet(advancedSnippet),
    setIsEditing: setIsEditing
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, hasDraft && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_sync_rules_callouts.SyncRulesStateCallouts, {
    applyDraft: applyDraft,
    editDraft: () => setIsEditing(true),
    state: draftState
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.description', {
    defaultMessage: `Include or exclude high level items, file types and (file or folder) paths to
                    synchronize from {indexName}. Everything is included by default. Each document is
                    tested against the rules below and the first rule that matches will be applied.`,
    values: {
      indexName
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "entSearchContent-connector-syncRules-learnMoreLink",
    "data-telemetry-id": "entSearchContent-connector-syncRules-learnMoreLink",
    href: _doc_links.docLinks.syncRules,
    external: true,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.syncRulesLabel', {
    defaultMessage: 'Learn more about sync rules'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchConnectorSyncRulesButton",
    "data-telemetry-id": "entSearchContent-connector-syncRules-editRules-editDraftRules",
    color: "primary",
    onClick: () => setIsEditing(!isEditing)
  }, hasDraft ? _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.editFilterRulesTitle', {
    defaultMessage: 'Edit sync rules'
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.draftNewFilterRulesTitle', {
    defaultMessage: 'Draft new sync rules'
  }))))), hasBasicFilteringFeature && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "plain",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.basicRulesTitle', {
    defaultMessage: 'Basic rules'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.basicRulesDescription', {
    defaultMessage: 'These rules apply to documents during the integration filtering phase.'
  })))), /*#__PURE__*/_react.default.createElement(_filtering_rules_table.FilteringRulesTable, {
    filteringRules: filteringRules,
    showOrder: true
  })))), hasAdvancedFilteringFeature && !isAdvancedSnippetEmpty && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "plain",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.advancedRulesTitle', {
    defaultMessage: 'Advanced rules'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.advancedFiltersDescription', {
    defaultMessage: 'These rules apply before the data is obtained from the data source.'
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "entSearchContent-connector-syncRules-learnMoreLink",
    "data-telemetry-id": "entSearchContent-connector-syncRules-learnMoreLink",
    external: true,
    href: _doc_links.docLinks.syncRulesAdvanced,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.advancedFiltersLinkTitle', {
    defaultMessage: 'Learn more about advanced sync rules.'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    language: "json"
  }, advancedSnippet), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.advancedRulesCalloutTitle', {
      defaultMessage: 'Configuration'
    }),
    color: "warning",
    iconType: "info"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.advancedRulesCalloutDescription', {
    defaultMessage: 'This advanced sync rule might override some configuration fields.'
  }))))))))));
};
exports.ConnectorSyncRules = ConnectorSyncRules;