"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorViewLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../common/types/api");
var _cached_fetch_connector_by_id_api_logic = require("../../api/connector/cached_fetch_connector_by_id_api_logic");
var _generate_connector_api_key_api_logic = require("../../api/connector/generate_connector_api_key_api_logic");
var _update_connector_configuration_api_logic = require("../../api/connector/update_connector_configuration_api_logic");
var _fetch_index_api_logic = require("../../api/index/fetch_index_api_logic");
var _connector_helpers = require("../../utils/connector_helpers");
var _connector_status_helpers = require("../../utils/connector_status_helpers");
var _connector_name_and_description_logic = require("./connector_name_and_description_logic");
var _deployment_logic = require("./deployment_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorViewLogic = exports.ConnectorViewLogic = (0, _kea.kea)({
  actions: {},
  connect: {
    actions: [_cached_fetch_connector_by_id_api_logic.CachedFetchConnectorByIdApiLogic, ['makeRequest as fetchConnector', 'apiSuccess as fetchConnectorApiSuccess', 'apiError as fetchConnectorApiError', 'apiReset as fetchConnectorApiReset', 'startPolling as startConnectorPoll', 'stopPolling as stopConnectorPoll'], _fetch_index_api_logic.FetchIndexApiLogic, ['makeRequest as fetchIndex', 'apiSuccess as fetchIndexApiSuccess', 'apiError as fetchIndexApiError', 'apiReset as fetchIndexApiReset'], _update_connector_configuration_api_logic.ConnectorConfigurationApiLogic, ['makeRequest as updateConnectorConfiguration', 'apiSuccess as updateConnectorConfigurationSuccess'], _connector_name_and_description_logic.ConnectorNameAndDescriptionLogic, ['apiSuccess as nameAndDescriptionApiSuccess', 'apiError as nameAndDescriptionApiError'], _deployment_logic.DeploymentLogic, ['generateConfigurationSuccess'], _generate_connector_api_key_api_logic.GenerateConnectorApiKeyApiLogic, ['apiSuccess as generateApiKeySuccess']],
    values: [_cached_fetch_connector_by_id_api_logic.CachedFetchConnectorByIdApiLogic, ['status as fetchConnectorApiStatus', 'connectorData', 'isInitialLoading'], _fetch_index_api_logic.FetchIndexApiLogic, ['data as index', 'status as fetchIndexApiStatus'], _update_connector_configuration_api_logic.ConnectorConfigurationApiLogic, ['status as updateConnectorConfigurationStatus']]
  },
  events: ({
    actions
  }) => ({
    beforeUnmount: () => {
      actions.stopConnectorPoll();
      actions.fetchConnectorApiReset();
    }
  }),
  listeners: ({
    actions,
    values
  }) => ({
    fetchConnectorApiSuccess: ({
      connector
    }) => {
      if (!values.index && connector !== null && connector !== void 0 && connector.index_name) {
        actions.fetchIndex({
          indexName: connector.index_name
        });
      }
    },
    generateApiKeySuccess: () => {
      if (values.connectorId) {
        actions.fetchConnector({
          connectorId: values.connectorId
        });
      }
    },
    generateConfigurationSuccess: () => {
      if (values.connectorId) {
        actions.fetchConnector({
          connectorId: values.connectorId
        });
      }
    },
    nameAndDescriptionApiError: () => {
      if (values.connectorId) {
        actions.fetchConnector({
          connectorId: values.connectorId
        });
      }
    },
    nameAndDescriptionApiSuccess: () => {
      if (values.connectorId) {
        actions.fetchConnector({
          connectorId: values.connectorId
        });
      }
    },
    updateConnectorConfigurationSuccess: () => {
      if (values.connectorId) {
        actions.fetchConnector({
          connectorId: values.connectorId
        });
      }
    }
  }),
  path: ['enterprise_search', 'content', 'connector_view_logic'],
  selectors: ({
    selectors
  }) => ({
    connector: [() => [selectors.connectorData], connectorData => {
      return connectorData;
    }],
    connectorError: [() => [selectors.connector], connector => connector === null || connector === void 0 ? void 0 : connector.error],
    connectorId: [() => [selectors.connector], connector => connector === null || connector === void 0 ? void 0 : connector.id],
    error: [() => [selectors.connector], connector => (connector === null || connector === void 0 ? void 0 : connector.error) || (connector === null || connector === void 0 ? void 0 : connector.last_sync_error) || (connector === null || connector === void 0 ? void 0 : connector.last_access_control_sync_error) || connector && (0, _connector_status_helpers.isLastSeenOld)(connector) && (0, _connector_status_helpers.getConnectorLastSeenError)(connector) || null],
    hasAdvancedFilteringFeature: [() => [selectors.connector], connector => (0, _connector_helpers.hasAdvancedFilteringFeature)(connector)],
    hasBasicFilteringFeature: [() => [selectors.connector], connector => (0, _connector_helpers.hasBasicFilteringFeature)(connector)],
    hasDocumentLevelSecurityFeature: [() => [selectors.connector], connector => (0, _connector_helpers.hasDocumentLevelSecurityFeature)(connector)],
    hasFilteringFeature: [() => [selectors.hasAdvancedFilteringFeature, selectors.hasBasicFilteringFeature], (advancedFeature, basicFeature) => advancedFeature || basicFeature],
    hasIncrementalSyncFeature: [() => [selectors.connector], connector => (0, _connector_helpers.hasIncrementalSyncFeature)(connector)],
    htmlExtraction: [() => [selectors.connector], connector => {
      var _connector$configurat, _connector$configurat2;
      return (_connector$configurat = connector === null || connector === void 0 ? void 0 : (_connector$configurat2 = connector.configuration.extract_full_html) === null || _connector$configurat2 === void 0 ? void 0 : _connector$configurat2.value) !== null && _connector$configurat !== void 0 ? _connector$configurat : undefined;
    }],
    indexName: [() => [selectors.connector], connector => {
      return (connector === null || connector === void 0 ? void 0 : connector.index_name) || undefined;
    }],
    isLoading: [() => [selectors.fetchConnectorApiStatus, selectors.fetchIndexApiStatus, selectors.index], (fetchConnectorApiStatus, fetchIndexApiStatus, index) => [_api.Status.IDLE && _api.Status.LOADING].includes(fetchConnectorApiStatus) || index && [_api.Status.IDLE && _api.Status.LOADING].includes(fetchIndexApiStatus)],
    pipelineData: [() => [selectors.connector], connector => {
      var _connector$pipeline;
      return (_connector$pipeline = connector === null || connector === void 0 ? void 0 : connector.pipeline) !== null && _connector$pipeline !== void 0 ? _connector$pipeline : undefined;
    }]
  })
});