"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchExtractionRules = exports.FetchExtractionRulesApiLogic = void 0;
var _create_api_logic = require("../../../../shared/api_logic/create_api_logic");
var _http = require("../../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchExtractionRules = async ({
  domainId,
  indexName
}) => {
  const route = `/internal/enterprise_search/indices/${indexName}/crawler/domains/${domainId}/extraction_rules`;
  return await _http.HttpLogic.values.http.get(route);
};
exports.fetchExtractionRules = fetchExtractionRules;
const FetchExtractionRulesApiLogic = exports.FetchExtractionRulesApiLogic = (0, _create_api_logic.createApiLogic)(['fetch_extraction_rule_api_logic'], fetchExtractionRules);