"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceEngines = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _app_logic = require("../../app_logic");
var _engine = require("../engine");
var _layout = require("../layout");
var _components = require("./components");
var _i18n = require("./i18n");
var _source_engines_logic = require("./source_engines_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceEngines = () => {
  const {
    myRole: {
      canManageMetaEngineSourceEngines
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    fetchIndexedEngines,
    fetchSourceEngines
  } = (0, _kea.useActions)(_source_engines_logic.SourceEnginesLogic);
  const {
    dataLoading,
    isModalOpen
  } = (0, _kea.useValues)(_source_engines_logic.SourceEnginesLogic);
  (0, _react.useEffect)(() => {
    fetchIndexedEngines();
    fetchSourceEngines();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _engine.getEngineBreadcrumbs)([_i18n.SOURCE_ENGINES_TITLE]),
    pageHeader: {
      pageTitle: _i18n.SOURCE_ENGINES_TITLE,
      rightSideItems: canManageMetaEngineSourceEngines ? [/*#__PURE__*/_react.default.createElement(_components.AddSourceEnginesButton, null)] : []
    },
    isLoading: dataLoading
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_components.SourceEnginesTable, null), isModalOpen && /*#__PURE__*/_react.default.createElement(_components.AddSourceEnginesModal, null)));
};
exports.SourceEngines = SourceEngines;