"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchUIForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _engine = require("../../engine");
var _i18n = require("../i18n");
var _search_ui_logic = require("../search_ui_logic");
var _types = require("../types");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchUIForm = () => {
  const {
    searchKey
  } = (0, _kea.useValues)(_engine.EngineLogic);
  const {
    dataLoading,
    validFields,
    validSortFields,
    validFacetFields,
    titleField,
    urlField,
    thumbnailField,
    facetFields,
    sortFields
  } = (0, _kea.useValues)(_search_ui_logic.SearchUILogic);
  const {
    onActiveFieldChange,
    onFacetFieldsChange,
    onSortFieldsChange,
    onTitleFieldChange,
    onUrlFieldChange,
    onThumbnailFieldChange
  } = (0, _kea.useActions)(_search_ui_logic.SearchUILogic);
  const previewHref = (0, _utils.generatePreviewUrl)({
    titleField,
    urlField,
    thumbnailField,
    facets: facetFields,
    sortFields
  });
  const formatSelectOption = fieldName => {
    return {
      text: fieldName,
      value: fieldName
    };
  };
  const formatMultiOptions = fieldNames => fieldNames.map(fieldName => ({
    label: fieldName,
    text: fieldName,
    value: fieldName
  }));
  const formatMultiOptionsWithEmptyOption = fieldNames => [{
    label: '',
    text: '',
    value: ''
  }, ...formatMultiOptions(fieldNames)];
  const optionFields = formatMultiOptionsWithEmptyOption(validFields);
  const sortOptionFields = formatMultiOptions(validSortFields);
  const facetOptionFields = formatMultiOptions(validFacetFields);
  const selectedTitleOption = formatSelectOption(titleField);
  const selectedURLOption = formatSelectOption(urlField);
  const selectedThumbnailOption = formatSelectOption(thumbnailField);
  const selectedSortOptions = formatMultiOptions(sortFields);
  const selectedFacetOptions = formatMultiOptions(facetFields);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    action: previewHref,
    target: "_blank",
    method: "POST"
  }, /*#__PURE__*/_react.default.createElement("input", {
    type: "hidden",
    id: "searchKey",
    name: "searchKey",
    value: searchKey
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.TITLE_FIELD_LABEL,
    helpText: _i18n.TITLE_FIELD_HELP_TEXT,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    disabled: dataLoading,
    options: optionFields,
    value: selectedTitleOption && selectedTitleOption.value,
    onChange: e => onTitleFieldChange(e.target.value),
    fullWidth: true,
    onFocus: () => onActiveFieldChange(_types.ActiveField.Title),
    onBlur: () => onActiveFieldChange(_types.ActiveField.None),
    hasNoInitialSelection: true,
    "data-test-subj": "selectTitle"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.FILTER_FIELD_LABEL,
    helpText: _i18n.FILTER_FIELD_HELP_TEXT,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isDisabled: dataLoading,
    options: facetOptionFields,
    selectedOptions: selectedFacetOptions,
    onChange: newValues => onFacetFieldsChange(newValues.map(field => field.value)),
    onFocus: () => onActiveFieldChange(_types.ActiveField.Filter),
    onBlur: () => onActiveFieldChange(_types.ActiveField.None),
    fullWidth: true,
    "data-test-subj": "selectFilters"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.SORT_FIELD_LABEL,
    helpText: _i18n.SORT_FIELD_HELP_TEXT,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isDisabled: dataLoading,
    options: sortOptionFields,
    selectedOptions: selectedSortOptions,
    onChange: newValues => onSortFieldsChange(newValues.map(field => field.value)),
    onFocus: () => onActiveFieldChange(_types.ActiveField.Sort),
    onBlur: () => onActiveFieldChange(_types.ActiveField.None),
    fullWidth: true,
    "data-test-subj": "selectSort"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.URL_FIELD_LABEL,
    helpText: _i18n.URL_FIELD_HELP_TEXT,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    disabled: dataLoading,
    options: optionFields,
    value: selectedURLOption && selectedURLOption.value,
    onChange: e => onUrlFieldChange(e.target.value),
    fullWidth: true,
    onFocus: () => onActiveFieldChange(_types.ActiveField.Url),
    onBlur: () => onActiveFieldChange(_types.ActiveField.None),
    hasNoInitialSelection: true,
    "data-test-subj": "selectUrl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.THUMBNAIL_FIELD_LABEL,
    helpText: _i18n.THUMBNAIL_FIELD_HELP_TEXT,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    disabled: dataLoading,
    options: optionFields,
    value: selectedThumbnailOption && selectedThumbnailOption.value,
    onChange: e => onThumbnailFieldChange(e.target.value),
    fullWidth: true,
    onFocus: () => onActiveFieldChange(_types.ActiveField.Thumb),
    onBlur: () => onActiveFieldChange(_types.ActiveField.None),
    hasNoInitialSelection: true,
    "data-test-subj": "selectThumbnail"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: dataLoading,
    type: "submit",
    fill: true,
    iconType: "popout",
    iconSide: "right",
    "data-test-subj": "generateSearchUiPreview"
  }, _i18n.GENERATE_PREVIEW_BUTTON_LABEL));
};
exports.SearchUIForm = SearchUIForm;