"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALUE_DISPLAY = exports.UPDATE_SUCCESS_MESSAGE = exports.SUCCESS_CHANGES_MESSAGE = exports.RESET_CONFIRMATION_MESSAGE = exports.RELEVANCE_TUNING_TITLE = exports.PROXIMITY_DISPLAY = exports.PROXIMITY_BOOST_FUNCTION_DISPLAY_MAP = exports.MULTIPLY_DISPLAY = exports.LOGARITHMIC_DISPLAY = exports.LINEAR_DISPLAY = exports.GAUSSIAN_DISPLAY = exports.FUNCTIONAL_DISPLAY = exports.FUNCTIONAL_BOOST_FUNCTION_DISPLAY_MAP = exports.FIELD_FILTER_CUTOFF = exports.EXPONENTIAL_DISPLAY = exports.DELETE_SUCCESS_MESSAGE = exports.DELETE_CONFIRMATION_MESSAGE = exports.BOOST_TYPE_TO_ICON_MAP = exports.BOOST_TYPE_TO_EMPTY_BOOST = exports.BOOST_TYPE_TO_DISPLAY_MAP = exports.BOOST_OPERATION_DISPLAY_MAP = exports.ADD_DISPLAY = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIELD_FILTER_CUTOFF = exports.FIELD_FILTER_CUTOFF = 10;
const RELEVANCE_TUNING_TITLE = exports.RELEVANCE_TUNING_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.title', {
  defaultMessage: 'Relevance Tuning'
});
const UPDATE_SUCCESS_MESSAGE = exports.UPDATE_SUCCESS_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.messages.updateSuccess', {
  defaultMessage: 'Relevance was tuned'
});
const DELETE_SUCCESS_MESSAGE = exports.DELETE_SUCCESS_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.messages.deleteSuccess', {
  defaultMessage: 'Relevance was reset to default values'
});
const SUCCESS_CHANGES_MESSAGE = exports.SUCCESS_CHANGES_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.messages.successDescription', {
  defaultMessage: 'The changes will impact your results shortly.'
});
const RESET_CONFIRMATION_MESSAGE = exports.RESET_CONFIRMATION_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.messages.resetConfirmation', {
  defaultMessage: 'Are you sure you want to restore relevance defaults?'
});
const DELETE_CONFIRMATION_MESSAGE = exports.DELETE_CONFIRMATION_MESSAGE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.messages.deleteConfirmation', {
  defaultMessage: 'Are you sure you want to delete this boost?'
});
const PROXIMITY_DISPLAY = exports.PROXIMITY_DISPLAY = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.boosts.proximityDropDownOptionLabel', {
  defaultMessage: 'Proximity'
});
const FUNCTIONAL_DISPLAY = exports.FUNCTIONAL_DISPLAY = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.boosts.functionalDropDownOptionLabel', {
  defaultMessage: 'Functional'
});
const VALUE_DISPLAY = exports.VALUE_DISPLAY = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.boosts.valueDropDownOptionLabel', {
  defaultMessage: 'Value'
});
const BOOST_TYPE_TO_DISPLAY_MAP = exports.BOOST_TYPE_TO_DISPLAY_MAP = {
  [_types.BoostType.Proximity]: PROXIMITY_DISPLAY,
  [_types.BoostType.Functional]: FUNCTIONAL_DISPLAY,
  [_types.BoostType.Value]: VALUE_DISPLAY
};
const BOOST_TYPE_TO_ICON_MAP = exports.BOOST_TYPE_TO_ICON_MAP = {
  [_types.BoostType.Value]: 'tokenNumber',
  [_types.BoostType.Functional]: 'tokenFunction',
  [_types.BoostType.Proximity]: 'tokenGeo'
};
const EMPTY_VALUE_BOOST = {
  type: _types.BoostType.Value,
  factor: 1,
  value: [''],
  newBoost: true,
  function: undefined,
  operation: undefined
};
const EMPTY_FUNCTIONAL_BOOST = {
  value: undefined,
  type: _types.BoostType.Functional,
  factor: 1,
  newBoost: true,
  function: _types.FunctionalBoostFunction.Logarithmic,
  operation: _types.BoostOperation.Multiply
};
const EMPTY_PROXIMITY_BOOST = {
  value: undefined,
  type: _types.BoostType.Proximity,
  factor: 1,
  newBoost: true,
  operation: undefined,
  function: _types.ProximityBoostFunction.Gaussian
};
const BOOST_TYPE_TO_EMPTY_BOOST = exports.BOOST_TYPE_TO_EMPTY_BOOST = {
  [_types.BoostType.Value]: EMPTY_VALUE_BOOST,
  [_types.BoostType.Functional]: EMPTY_FUNCTIONAL_BOOST,
  [_types.BoostType.Proximity]: EMPTY_PROXIMITY_BOOST
};
const ADD_DISPLAY = exports.ADD_DISPLAY = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.boosts.addOperationDropDownOptionLabel', {
  defaultMessage: 'Add'
});
const MULTIPLY_DISPLAY = exports.MULTIPLY_DISPLAY = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.boosts.multiplyOperationDropDownOptionLabel', {
  defaultMessage: 'Multiply'
});
const BOOST_OPERATION_DISPLAY_MAP = exports.BOOST_OPERATION_DISPLAY_MAP = {
  [_types.BoostOperation.Add]: ADD_DISPLAY,
  [_types.BoostOperation.Multiply]: MULTIPLY_DISPLAY
};
const LOGARITHMIC_DISPLAY = exports.LOGARITHMIC_DISPLAY = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.boosts.logarithmicBoostFunctionDropDownOptionLabel', {
  defaultMessage: 'Logarithmic'
});
const GAUSSIAN_DISPLAY = exports.GAUSSIAN_DISPLAY = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.boosts.gaussianFunctionDropDownOptionLabel', {
  defaultMessage: 'Gaussian'
});
const EXPONENTIAL_DISPLAY = exports.EXPONENTIAL_DISPLAY = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.boosts.exponentialFunctionDropDownOptionLabel', {
  defaultMessage: 'Exponential'
});
const LINEAR_DISPLAY = exports.LINEAR_DISPLAY = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.boosts.linearFunctionDropDownOptionLabel', {
  defaultMessage: 'Linear'
});
const PROXIMITY_BOOST_FUNCTION_DISPLAY_MAP = exports.PROXIMITY_BOOST_FUNCTION_DISPLAY_MAP = {
  [_types.ProximityBoostFunction.Gaussian]: GAUSSIAN_DISPLAY,
  [_types.ProximityBoostFunction.Exponential]: EXPONENTIAL_DISPLAY,
  [_types.ProximityBoostFunction.Linear]: LINEAR_DISPLAY
};
const FUNCTIONAL_BOOST_FUNCTION_DISPLAY_MAP = exports.FUNCTIONAL_BOOST_FUNCTION_DISPLAY_MAP = {
  [_types.FunctionalBoostFunction.Logarithmic]: LOGARITHMIC_DISPLAY,
  [_types.FunctionalBoostFunction.Exponential]: EXPONENTIAL_DISPLAY,
  [_types.FunctionalBoostFunction.Linear]: LINEAR_DISPLAY
};