"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnginesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _app_logic = require("../../../../app_logic");
var _constants = require("../../../../constants");
var _audit_logs_modal_logic = require("../audit_logs_modal/audit_logs_modal_logic");
var _engine_link_helpers = require("./engine_link_helpers");
var _shared_columns = require("./shared_columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LANGUAGE_COLUMN = {
  field: 'language',
  name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.enginesOverview.table.column.language', {
    defaultMessage: 'Language'
  }),
  dataType: 'string',
  render: language => language || _constants.UNIVERSAL_LANGUAGE
};
const EnginesTable = ({
  items,
  loading,
  noItemsMessage,
  pagination,
  onChange
}) => {
  const {
    myRole: {
      canManageEngines
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    showModal: showAuditLogModal
  } = (0, _kea.useActions)(_audit_logs_modal_logic.AuditLogsModalLogic);
  const columns = [{
    ..._shared_columns.NAME_COLUMN,
    render: name => (0, _engine_link_helpers.renderEngineLink)(name)
  }, _shared_columns.CREATED_AT_COLUMN, {
    ..._shared_columns.LAST_UPDATED_COLUMN,
    render: (dateString, engineDetails) => {
      return (0, _engine_link_helpers.renderLastChangeLink)(dateString, () => {
        showAuditLogModal(engineDetails.name);
      });
    }
  }, LANGUAGE_COLUMN, _shared_columns.DOCUMENT_COUNT_COLUMN, _shared_columns.FIELD_COUNT_COLUMN];
  if (canManageEngines) {
    columns.push(_shared_columns.ACTIONS_COLUMN);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: items,
    columns: columns,
    loading: loading,
    pagination: pagination,
    onChange: onChange,
    noItemsMessage: noItemsMessage
  });
};
exports.EnginesTable = EnginesTable;