"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineOverview = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _app_logic = require("../../app_logic");
var _engine = require("../engine");
var _engine_overview_empty = require("./engine_overview_empty");
var _engine_overview_metrics = require("./engine_overview_metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EngineOverview = () => {
  const {
    myRole: {
      canManageEngineDocuments,
      canViewEngineCredentials
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    hasNoDocuments,
    isMetaEngine
  } = (0, _kea.useValues)(_engine.EngineLogic);
  const canAddDocuments = canManageEngineDocuments && canViewEngineCredentials;
  const showEngineOverview = !hasNoDocuments || !canAddDocuments || isMetaEngine;
  return showEngineOverview ? /*#__PURE__*/_react.default.createElement(_engine_overview_metrics.EngineOverviewMetrics, null) : /*#__PURE__*/_react.default.createElement(_engine_overview_empty.EmptyEngineOverview, null);
};
exports.EngineOverview = EngineOverview;