"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Documents = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _app_logic = require("../../app_logic");
var _engine = require("../engine");
var _layout = require("../layout");
var _components = require("./components");
var _constants = require("./constants");
var _search_experience = require("./search_experience");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Documents = () => {
  const {
    isMetaEngine,
    isElasticsearchEngine,
    hasNoDocuments,
    engine: {
      elasticsearchIndexName
    }
  } = (0, _kea.useValues)(_engine.EngineLogic);
  const {
    myRole
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const showDocumentCreationButton = myRole.canManageEngineDocuments && !isMetaEngine && !isElasticsearchEngine;
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _engine.getEngineBreadcrumbs)([_constants.DOCUMENTS_TITLE]),
    pageHeader: {
      pageTitle: _constants.DOCUMENTS_TITLE,
      rightSideItems: showDocumentCreationButton ? [/*#__PURE__*/_react.default.createElement(_components.DocumentCreationButton, null)] : []
    },
    isEmptyState: hasNoDocuments,
    emptyState: /*#__PURE__*/_react.default.createElement(_components.EmptyState, null)
  }, isMetaEngine && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "MetaEnginesCallout",
    iconType: "iInCircle",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.metaEngineCallout.title', {
      defaultMessage: 'You are within a Meta Engine.'
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.metaEngineCallout', {
    defaultMessage: 'Meta Engines have many Source Engines. Visit your Source Engines to alter their documents.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), isElasticsearchEngine && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "ElasticsearchEnginesCallout",
    iconType: "iInCircle",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.elasticsearchEngineCallout.title', {
      defaultMessage: "This engine's data is managed by Elasticsearch."
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documents.elasticsearchEngineCallout', {
    defaultMessage: "The engine is attached to {elasticsearchIndexName}. You can modify this index's data in Kibana.",
    values: {
      elasticsearchIndexName
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_search_experience.SearchExperience, null));
};
exports.Documents = Documents;