"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurationsOverview = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _engine = require("../../engine");
var _components = require("../components");
var _suggestions_table = require("../components/suggestions_table");
var _curations_logic = require("../curations_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CurationsOverview = () => {
  const {
    curations
  } = (0, _kea.useValues)(_curations_logic.CurationsLogic);
  const {
    engine: {
      adaptive_relevance_suggestions_active: adaptiveRelevanceSuggestionsActive
    }
  } = (0, _kea.useValues)(_engine.EngineLogic);
  const shouldShowSuggestions = adaptiveRelevanceSuggestionsActive;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, shouldShowSuggestions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_suggestions_table.SuggestionsTable, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), curations.length > 0 ? /*#__PURE__*/_react.default.createElement(_components.CurationsTable, null) : /*#__PURE__*/_react.default.createElement(_components.EmptyState, null));
};
exports.CurationsOverview = CurationsOverview;