"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteCurationButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../../../shared/constants");
var _constants2 = require("../constants");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteCurationButton = () => {
  const {
    curationId
  } = (0, _reactRouterDom.useParams)();
  const {
    deleteCuration
  } = (0, _kea.useActions)((0, _.CurationLogic)({
    curationId
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    iconType: "trash",
    onClick: () => {
      if (window.confirm(_constants2.DELETE_CONFIRMATION_MESSAGE)) deleteCuration();
    }
  }, _constants.DELETE_BUTTON_LABEL);
};
exports.DeleteCurationButton = DeleteCurationButton;