"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteDomainPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _crawler_single_domain_logic = require("../crawler_single_domain_logic");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteDomainPanel = ({}) => {
  const {
    domain
  } = (0, _kea.useValues)(_crawler_single_domain_logic.CrawlerSingleDomainLogic);
  const {
    deleteDomain
  } = (0, _kea.useActions)(_crawler_single_domain_logic.CrawlerSingleDomainLogic);
  if (!domain) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.deleteDomainPanel.title', {
    defaultMessage: 'Delete domain'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.appSearch.crawler.deleteDomainPanel.description",
    defaultMessage: "Remove this domain from your crawler. This will also delete all entry points and crawl rules you have setup. {cannotUndoMessage}.",
    values: {
      cannotUndoMessage: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.deleteDomainPanel.cannotUndoMessage', {
        defaultMessage: 'This cannot be undone'
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    iconType: "trash",
    onClick: () => {
      if (confirm((0, _utils.getDeleteDomainConfirmationMessage)(domain.url))) {
        deleteDomain(domain);
      }
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.deleteDomainPanel.deleteDomainButtonLabel', {
    defaultMessage: 'Delete domain'
  })));
};
exports.DeleteDomainPanel = DeleteDomainPanel;