"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlSelectDomainsModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../shared/constants");
var _crawler_logic = require("../../crawler_logic");
var _crawl_select_domains_modal_logic = require("./crawl_select_domains_modal_logic");
var _simplified_selectable = require("./simplified_selectable");
require("./crawl_select_domains_modal.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlSelectDomainsModal = () => {
  const {
    domains
  } = (0, _kea.useValues)(_crawler_logic.CrawlerLogic);
  const domainUrls = domains.map(domain => domain.url);
  const crawlSelectDomainsModalLogic = (0, _crawl_select_domains_modal_logic.CrawlSelectDomainsModalLogic)({
    domains
  });
  const {
    isDataLoading,
    isModalVisible,
    selectedDomainUrls
  } = (0, _kea.useValues)(crawlSelectDomainsModalLogic);
  const {
    hideModal,
    onSelectDomainUrls
  } = (0, _kea.useActions)(crawlSelectDomainsModalLogic);
  const {
    startCrawl
  } = (0, _kea.useActions)(_crawler_logic.CrawlerLogic);
  if (!isModalVisible) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: hideModal,
    className: "crawlSelectDomainsModal"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlSelectDomainsModal.modalHeaderTitle', {
    defaultMessage: 'Crawl select domains'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    size: "m",
    color: selectedDomainUrls.length > 0 ? 'accent' : 'subdued'
  }, selectedDomainUrls.length), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlSelectDomainsModal.selectedDescriptor', {
    defaultMessage: 'selected'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_simplified_selectable.SimplifiedSelectable, {
    options: domainUrls,
    selectedOptions: selectedDomainUrls,
    onChange: onSelectDomainUrls
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: hideModal
  }, _constants.CANCEL_BUTTON_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: () => {
      startCrawl({
        domain_allowlist: selectedDomainUrls
      });
    },
    disabled: selectedDomainUrls.length === 0,
    isLoading: isDataLoading
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlSelectDomainsModal.startCrawlButtonLabel', {
    defaultMessage: 'Apply and crawl now'
  }))));
};
exports.CrawlSelectDomainsModal = CrawlSelectDomainsModal;