"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlDetailsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _loading = require("../../../../../shared/loading");
var _log_retention = require("../../../log_retention");
var _crawl_detail_logic = require("../../crawl_detail_logic");
var _crawl_details_preview = require("./crawl_details_preview");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlDetailsFlyout = () => {
  const {
    closeFlyout,
    setSelectedTab
  } = (0, _kea.useActions)(_crawl_detail_logic.CrawlDetailLogic);
  const {
    crawlRequestFromServer,
    dataLoading,
    flyoutClosed,
    selectedTab
  } = (0, _kea.useValues)(_crawl_detail_logic.CrawlDetailLogic);
  const {
    fetchLogRetention
  } = (0, _kea.useActions)(_log_retention.LogRetentionLogic);
  const {
    logRetention
  } = (0, _kea.useValues)(_log_retention.LogRetentionLogic);
  (0, _react.useEffect)(() => {
    fetchLogRetention();
  }, []);
  if (flyoutClosed) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    maxWidth: "45rem",
    ownFocus: true,
    onClose: closeFlyout,
    "aria-labelledby": "CrawlDetailsFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "CrawlDetailsFlyoutTitle"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlDetailsFlyout.title', {
    defaultMessage: 'Crawl request details'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    style: {
      marginBottom: '-25px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === 'preview',
    onClick: () => setSelectedTab('preview')
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlDetailsFlyout.previewTabLabel', {
    defaultMessage: 'Preview'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === 'json',
    onClick: () => setSelectedTab('json')
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlDetailsFlyout.rawJSONTabLabel', {
    defaultMessage: 'Raw JSON'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, dataLoading ? /*#__PURE__*/_react.default.createElement(_loading.Loading, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedTab === 'preview' && /*#__PURE__*/_react.default.createElement(_crawl_details_preview.CrawlDetailsPreview, {
    crawlerLogsEnabled: logRetention ? logRetention.crawler.enabled : false
  }), selectedTab === 'json' && /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true
  }, JSON.stringify(crawlRequestFromServer, null, 2)))));
};
exports.CrawlDetailsFlyout = CrawlDetailsFlyout;