"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.javascriptEmbedSteps = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const javascriptEmbedSteps = (webClientSrc, analyticsConfig) => [{
  title: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.javascriptEmbed.stepOne.title', {
    defaultMessage: 'Embed onto site'
  }),
  children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.javascriptEmbed.stepOne.description', {
    defaultMessage: 'Embed the behavioral analytics JavaScript snippet on every page of the website or application you’d like to track.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "html",
    isCopyable: true
  }, `<script src="${webClientSrc}"></script>`)))
}, {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.javascriptEmbed.stepTwo.title', {
    defaultMessage: 'Initialize the client'
  }),
  children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.javascriptEmbed.stepTwo.description', {
    defaultMessage: 'You must initialize the client before you can track events. We recommend initializing just below the script tag.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "html",
    isCopyable: true
  }, `<script type="text/javascript">
window.elasticAnalytics.createTracker({
  endpoint: "${analyticsConfig.endpoint}",
  collectionName: "${analyticsConfig.collectionName}",
  apiKey: "${analyticsConfig.apiKey}",
  // Optional: sampling rate percentage: 0-1, 0 = no events, 1 = all events
  // sampling: 1,
});
</script>`)))
}, {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.javascriptEmbed.stepThree.title', {
    defaultMessage: 'Track search events'
  }),
  children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.javascriptEmbed.stepThree.description",
    defaultMessage: "Track individual search events, like result clicks and searches, by using the trackSearch or trackSearchClick methods."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "javascript",
    isCopyable: true
  }, `window.elasticAnalytics.trackSearch({
  search: {
    query: "laptop",
    filters: {
      brand: ["apple"],
      price: ["1000-2000"],
    },
    page: {
      current: 1,
      size: 10,
    },
    results: {
      items: [
        {
          document: {
            id: "123",
            index: "products",
          },
          page: {
            url: "http://my-website.com/products/123",
          },
        },
      ],
      total_results: 100,
    },
    sort: {
      name: "relevance",
    },
    search_application: "website",
  }
});`)))
}];
exports.javascriptEmbedSteps = javascriptEmbedSteps;