"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RankAggregationSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _linear = _interopRequireDefault(require("../../../../assets/images/linear.svg"));
var _rrf = _interopRequireDefault(require("../../../../assets/images/rrf.svg"));
var _ai_search_guide_accordion = require("./ai_search_guide_accordion");
var _linear_combination_panel = require("./linear_combination_panel");
var _rrf_ranking_panel = require("./rrf_ranking_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RankAggregationSection = () => {
  const [currentExpandedId, setCurrentExpandedId] = (0, _react.useState)(undefined);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.aiSearch.rankAggregationSection.title",
    defaultMessage: "Hybrid search"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.aiSearch.rankAggregationSection.description",
    defaultMessage: "Combine rankings from different search algorithms for superior overall relevance. For example, combine the results of keyword search and dense or sparse vector search."
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_ai_search_guide_accordion.AISearchGuideAccordion, {
    id: "rrfRankingAccordion",
    "data-telemetry-id": "entSearch-aiSearch-rankAggregation-rrfRankingAccordion",
    icon: _rrf.default,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.rrfRankingAccordion.title', {
      defaultMessage: 'RRF hybrid ranking'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.rrfRankingAccordion.description', {
      defaultMessage: 'Intelligently combines rankings without configuration'
    }),
    currentExpandedId: currentExpandedId,
    onToggle: setCurrentExpandedId
  }, /*#__PURE__*/_react.default.createElement(_rrf_ranking_panel.RrfRankingPanel, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_ai_search_guide_accordion.AISearchGuideAccordion, {
    id: "linearCombinationAccordion",
    "data-telemetry-id": "entSearch-aiSearch-rankAggregation-linearCombinationAccordion",
    icon: _linear.default,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.linearCombinationAccordion.title', {
      defaultMessage: 'Linear combination'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.linearCombinationAccordion.description', {
      defaultMessage: 'Weighted results from multiple rankings'
    }),
    currentExpandedId: currentExpandedId,
    onToggle: setCurrentExpandedId
  }, /*#__PURE__*/_react.default.createElement(_linear_combination_panel.LinearCombinationPanel, null))))));
};
exports.RankAggregationSection = RankAggregationSection;