"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAX_HALLUCINATION_FAILURES = exports.MAX_GENERATION_ATTEMPTS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_HALLUCINATION_FAILURES = hallucinationFailures => _i18n.i18n.translate('xpack.elasticAssistantPlugin.attackDiscovery.defaultAttackDiscoveryGraph.nodes.retriever.helpers.throwIfErrorCountsExceeded.maxHallucinationFailuresErrorMessage', {
  defaultMessage: 'Maximum hallucination failures ({hallucinationFailures}) reached. Try sending fewer alerts to this model.',
  values: {
    hallucinationFailures
  }
});
exports.MAX_HALLUCINATION_FAILURES = MAX_HALLUCINATION_FAILURES;
const MAX_GENERATION_ATTEMPTS = generationAttempts => _i18n.i18n.translate('xpack.elasticAssistantPlugin.attackDiscovery.defaultAttackDiscoveryGraph.nodes.retriever.helpers.throwIfErrorCountsExceeded.maxGenerationAttemptsErrorMessage', {
  defaultMessage: 'Maximum generation attempts ({generationAttempts}) reached. Try sending fewer alerts to this model.',
  values: {
    generationAttempts
  }
});
exports.MAX_GENERATION_ATTEMPTS = MAX_GENERATION_ATTEMPTS;