"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateAttackDiscoverySchedulesResponse = exports.UpdateAttackDiscoverySchedulesRequestParams = exports.UpdateAttackDiscoverySchedulesRequestBody = exports.GetAttackDiscoverySchedulesResponse = exports.GetAttackDiscoverySchedulesRequestParams = exports.EnableAttackDiscoverySchedulesResponse = exports.EnableAttackDiscoverySchedulesRequestParams = exports.DisableAttackDiscoverySchedulesResponse = exports.DisableAttackDiscoverySchedulesRequestParams = exports.DeleteAttackDiscoverySchedulesResponse = exports.DeleteAttackDiscoverySchedulesRequestParams = exports.CreateAttackDiscoverySchedulesResponse = exports.CreateAttackDiscoverySchedulesRequestBody = exports.AttackDiscoveryGenericResponse = exports.AttackDiscoveryGenericError = void 0;
var _zod = require("@kbn/zod");
var _schedules = require("./schedules.gen");
var _common_attributes = require("../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Attack discovery scheduling API endpoint
 *   version: 1
 */

/**
 * Object containing Attack Discovery schedule.
 */

const AttackDiscoveryGenericResponse = exports.AttackDiscoveryGenericResponse = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * An attack discovery generic error
 */

const AttackDiscoveryGenericError = exports.AttackDiscoveryGenericError = _zod.z.object({
  statusCode: _zod.z.number().optional(),
  error: _zod.z.string().optional(),
  message: _zod.z.string().optional()
});
const CreateAttackDiscoverySchedulesRequestBody = exports.CreateAttackDiscoverySchedulesRequestBody = _schedules.AttackDiscoveryScheduleCreateProps;
const CreateAttackDiscoverySchedulesResponse = exports.CreateAttackDiscoverySchedulesResponse = _schedules.AttackDiscoverySchedule;
const DeleteAttackDiscoverySchedulesRequestParams = exports.DeleteAttackDiscoverySchedulesRequestParams = _zod.z.object({
  /**
   * The Attack Discovery schedule's `id` value.
   */
  id: _common_attributes.NonEmptyString
});
const DeleteAttackDiscoverySchedulesResponse = exports.DeleteAttackDiscoverySchedulesResponse = _zod.z.object({
  id: _common_attributes.NonEmptyString
});
const DisableAttackDiscoverySchedulesRequestParams = exports.DisableAttackDiscoverySchedulesRequestParams = _zod.z.object({
  /**
   * The Attack Discovery schedule's `id` value.
   */
  id: _common_attributes.NonEmptyString
});
const DisableAttackDiscoverySchedulesResponse = exports.DisableAttackDiscoverySchedulesResponse = _zod.z.object({
  id: _common_attributes.NonEmptyString
});
const EnableAttackDiscoverySchedulesRequestParams = exports.EnableAttackDiscoverySchedulesRequestParams = _zod.z.object({
  /**
   * The Attack Discovery schedule's `id` value.
   */
  id: _common_attributes.NonEmptyString
});
const EnableAttackDiscoverySchedulesResponse = exports.EnableAttackDiscoverySchedulesResponse = _zod.z.object({
  id: _common_attributes.NonEmptyString
});
const GetAttackDiscoverySchedulesRequestParams = exports.GetAttackDiscoverySchedulesRequestParams = _zod.z.object({
  /**
   * The Attack Discovery schedule's `id` value.
   */
  id: _common_attributes.NonEmptyString
});
const GetAttackDiscoverySchedulesResponse = exports.GetAttackDiscoverySchedulesResponse = _schedules.AttackDiscoverySchedule;
const UpdateAttackDiscoverySchedulesRequestParams = exports.UpdateAttackDiscoverySchedulesRequestParams = _zod.z.object({
  /**
   * The Attack Discovery schedule's `id` value.
   */
  id: _common_attributes.NonEmptyString
});
const UpdateAttackDiscoverySchedulesRequestBody = exports.UpdateAttackDiscoverySchedulesRequestBody = _schedules.AttackDiscoveryScheduleUpdateProps;
const UpdateAttackDiscoverySchedulesResponse = exports.UpdateAttackDiscoverySchedulesResponse = _schedules.AttackDiscoverySchedule;